/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxEthNameResolver {
    private static final String[] exePaths = new String[]{"/sbin", "/usr/sbin", "/bin", "/usr/bin"};
    private static final String LSPCI_CMD = String.valueOf(LinuxEthNameResolver.locateExecutable("lspci")) + " -m";
    private static final Pattern LSPCI_MATCHER = Pattern.compile("(\\S+)\\s+\".*?\"\\s+\"(.*?)\"\\s+\"(.*?)\"\\s+.*");
    private static final String LS_NET_CMD = String.valueOf(LinuxEthNameResolver.locateExecutable("ls")) + " -g --no-group -Q /sys/class/net/";
    private static final Pattern LS_NET_PCI_MATCHER = Pattern.compile(".*?\\s->\\s\"(.*?)\"");
    private final List<PCIDevice> pciDevices = this.getPCIDevices();

    private static String locateExecutable(String exe) {
        String[] stringArray = exePaths;
        int n = exePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path, exe);
            if (file.isFile()) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return exe;
    }

    private String runCmdAndGetStdout(String command) {
        StringBuilder output;
        block27: {
            output = new StringBuilder();
            Process process = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String line;
                    process = Runtime.getRuntime().exec(command);
                    inputStreamReader = new InputStreamReader(process.getInputStream());
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        output.append(line);
                        output.append('\n');
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (IOException iOException3) {}
                    if (process != null) {
                        process.destroy();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {}
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
            if (process != null) {
                process.destroy();
            }
        }
        return output.toString();
    }

    protected String getLSPCIOutput() {
        return this.runCmdAndGetStdout(LSPCI_CMD);
    }

    protected List<PCIDevice> getPCIDevices() {
        String[] lspciLines;
        LinkedList<PCIDevice> devices = new LinkedList<PCIDevice>();
        String lspciOutput = this.getLSPCIOutput();
        String[] stringArray = lspciLines = lspciOutput.split("\n");
        int n = lspciLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = LSPCI_MATCHER.matcher(line);
            if (matcher.matches()) {
                String slot = matcher.group(1);
                String vendor = matcher.group(2);
                String description = matcher.group(3);
                devices.add(new PCIDevice(slot, vendor, description));
            }
            ++n2;
        }
        return devices;
    }

    protected String getLsNetOutput(String device) {
        return this.runCmdAndGetStdout(String.valueOf(LS_NET_CMD) + device);
    }

    public NetDevice getLsNetDevices(String device) {
        String[] lsNetLines;
        String lsNetOutput = this.getLsNetOutput(device);
        String[] stringArray = lsNetLines = lsNetOutput.split("\n");
        int n = lsNetLines.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            int pos1;
            String line = stringArray[n2];
            Matcher matcher = LS_NET_PCI_MATCHER.matcher(line);
            if (matcher.matches() && (pos1 = (path = matcher.group(1)).lastIndexOf(58)) != -1 && (pos1 = path.lastIndexOf(58, pos1 - 1)) != -1) {
                int pos2;
                if ((pos2 = path.indexOf(47, ++pos1)) == -1) {
                    pos2 = path.length();
                }
                String pcislot = path.substring(pos1, pos2);
                return new NetDevice(device, pcislot);
            }
            ++n2;
        }
        return null;
    }

    public String getDescriptionForDevice(String device) {
        NetDevice netDevice = this.getLsNetDevices(device);
        if (netDevice != null) {
            for (PCIDevice pciDevice : this.pciDevices) {
                if (!netDevice.pcislot.equals(pciDevice.slot)) continue;
                return String.valueOf(pciDevice.vendor) + " " + pciDevice.description;
            }
        }
        return null;
    }

    static class NetDevice {
        public final String name;
        public final String pcislot;

        public NetDevice(String name, String pcislot) {
            this.name = name;
            this.pcislot = pcislot;
        }
    }

    static class PCIDevice {
        public final String slot;
        public final String vendor;
        public final String description;

        public PCIDevice(String slot, String vendor, String description) {
            this.slot = slot;
            this.vendor = vendor;
            this.description = description;
        }
    }
}

