/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing;

import com.arm.licensing.license.ILicense;
import com.arm.licensing.license.InvalidLicenseException;
import java.util.HashMap;
import java.util.Map;

public class LicenseVerifier {
    private final LicenseVerifierCallback callback;
    private final Map<ILicense, Status> status = new HashMap<ILicense, Status>();
    private final Map<ILicense, InvalidLicenseException> results = new HashMap<ILicense, InvalidLicenseException>();

    public LicenseVerifier(LicenseVerifierCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyLicense(final ILicense license) {
        Map<ILicense, Status> map = this.status;
        synchronized (map) {
            this.status.put(license, Status.VERIFYING);
        }
        Thread thread = new Thread("Verifying license " + license.getDescription()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InvalidLicenseException result = null;
                try {
                    license.validateAll();
                }
                catch (InvalidLicenseException ile) {
                    result = ile;
                }
                Map map = LicenseVerifier.this.status;
                synchronized (map) {
                    LicenseVerifier.this.status.put(license, Status.COMPLETE);
                    LicenseVerifier.this.results.put(license, result);
                }
                if (LicenseVerifier.this.callback != null) {
                    LicenseVerifier.this.callback.handle(license);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus(ILicense license) {
        Map<ILicense, Status> map = this.status;
        synchronized (map) {
            return this.status.get(license);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvalidLicenseException getResult(ILicense license) {
        Map<ILicense, Status> map = this.status;
        synchronized (map) {
            return this.results.get(license);
        }
    }

    public static interface LicenseVerifierCallback {
        public void handle(ILicense var1);
    }

    public static enum Status {
        VERIFYING,
        COMPLETE;

    }
}

