/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing;

import com.arm.licensing.LinuxEthNameResolver;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class HostID
implements Comparable<HostID> {
    private static List<HostID> hostIDs;
    private final String description;
    private final String value;
    private final boolean possiblyVirtual;

    private HostID(String description, String value, boolean isVirtual) {
        this.description = description;
        this.value = value;
        this.possiblyVirtual = isVirtual;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public static synchronized List<HostID> getHostIDs() {
        if (hostIDs == null) {
            Enumeration<NetworkInterface> interfaces;
            hostIDs = new LinkedList<HostID>();
            try {
                interfaces = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException socketException) {
                return hostIDs;
            }
            LinuxEthNameResolver resolver = null;
            if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
                resolver = new LinuxEthNameResolver();
            }
            while (interfaces.hasMoreElements()) {
                try {
                    String linuxDesc;
                    byte[] mac;
                    NetworkInterface ni = interfaces.nextElement();
                    if (ni == null || ni.isPointToPoint() || (mac = ni.getHardwareAddress()) == null || mac.length == 0) continue;
                    String description = ni.getDisplayName();
                    if (resolver != null && (linuxDesc = resolver.getDescriptionForDevice(description)) != null) {
                        description = String.valueOf(description) + " (" + linuxDesc + ")";
                    }
                    StringBuilder value = new StringBuilder();
                    int i = 0;
                    while (i < mac.length) {
                        value.append(String.format("%02X", mac[i]));
                        ++i;
                    }
                    boolean possiblyVirtual = ni.isVirtual() || ni.isPointToPoint() || ni.getDisplayName().toLowerCase().startsWith("virbr") || ni.getDisplayName().toLowerCase().contains("virtual") || ni.getDisplayName().toLowerCase().contains("vmnet");
                    HostID hostId = new HostID(description, value.toString(), possiblyVirtual);
                    hostIDs.add(hostId);
                }
                catch (SocketException socketException) {}
            }
        }
        return hostIDs;
    }

    @Override
    public int compareTo(HostID o) {
        if (this.possiblyVirtual && !o.possiblyVirtual) {
            return 1;
        }
        if (!this.possiblyVirtual && o.possiblyVirtual) {
            return -1;
        }
        return this.value.compareTo(o.getValue());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostID other = (HostID)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return String.valueOf(this.getValue()) + " - " + this.getDescription();
    }
}

