/*
 * Decompiled with CFR 0.152.
 */
package com.arm.licensing;

import com.arm.io.TextFileUtils;
import com.arm.licensing.Messages;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;

public class ConfigFileEntry {
    private final Path path;
    private final EntryMatcher matcher;

    public ConfigFileEntry(Path path, EntryMatcher matcher) {
        this.path = path;
        this.matcher = matcher;
    }

    public String getLine() throws IOException {
        List<String> lines = this.readFileContent();
        for (String line : lines) {
            if (!this.matcher.matches(line)) continue;
            return line;
        }
        return null;
    }

    public void setLine(String content) throws IOException {
        List<Object> lines = new LinkedList();
        if (Files.isRegularFile(this.path, new LinkOption[0])) {
            lines = this.readFileContent();
        }
        boolean matched = false;
        int lineNum = 0;
        while (lineNum < lines.size()) {
            String line = (String)lines.get(lineNum);
            if (this.matcher.matches(line)) {
                if (content == null) {
                    lines.remove(lineNum);
                } else {
                    lines.set(lineNum, content);
                }
                matched = true;
                break;
            }
            ++lineNum;
        }
        if (!matched && content != null) {
            lines.add(content);
        }
        this.writeFileContent(lines);
    }

    private List<String> readFileContent() throws IOException {
        if (!Files.exists(this.path, new LinkOption[0]) || !Files.isReadable(this.path)) {
            return new LinkedList<String>();
        }
        return TextFileUtils.readContent((Path)this.path);
    }

    private void writeFileContent(List<String> content) throws IOException {
        if (content.size() == 0 && Files.isWritable(this.path) && Files.deleteIfExists(this.path)) {
            return;
        }
        Path parent = this.path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0]) && !parent.toFile().mkdirs()) {
            throw new IOException(Messages.ERROR_CAN_NOT_CREATE_DIRECTORY.getLocalisedValue(parent));
        }
        TextFileUtils.writeContent((Path)this.path, content);
    }

    public static interface EntryMatcher {
        public boolean matches(String var1);
    }
}

