/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IChannelSftp {
    public static @Nullable IChannelSftp wrap(final @Nullable ChannelSftp channel) {
        if (channel == null) {
            return null;
        }
        return new IChannelSftp(){
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            public void connect() throws JSchException {
                channel.connect(60000);
            }

            @Override
            public void disconnect() {
                channel.disconnect();
            }

            @Override
            public @NonNull File get(boolean recursive, @NonNull String remotePath, @NonNull String localPath, @NonNull SftpProgressMonitor progressMonitor, int mode) throws SftpException, IOException {
                SftpATTRS stat = channel.stat(remotePath);
                if (recursive && stat.isDir()) {
                    File localFile = new File(localPath);
                    File remoteFile = new File(remotePath);
                    File targetDir = new File(localPath, remoteFile.getName());
                    if (localFile.exists() && !localFile.isDirectory()) {
                        throw new IOException();
                    }
                    this.getRecursive(targetDir, remotePath, progressMonitor, mode);
                    return targetDir;
                }
                File localFile = new File(localPath);
                File remoteFile = new File(remotePath);
                channel.get(remotePath, localPath, progressMonitor, mode);
                if (localFile.isDirectory()) {
                    return new File(localFile, remoteFile.getName());
                }
                return localFile;
            }

            @Override
            public @Nullable String getHome() throws SftpException {
                return channel.getHome();
            }

            @Override
            public void put(@NonNull String localPath, final @NonNull String remotePath, final @NonNull SftpProgressMonitor progressMonitor, final int mode) throws SftpException {
                final Path source = Path.of(localPath, new String[0]);
                try {
                    Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            String relativePath = source.relativize(file).toString();
                            Object remoteFile = file.equals(source) || relativePath.isEmpty() ? remotePath : remotePath + "/" + relativePath;
                            if (!$assertionsDisabled && ((String)remoteFile).endsWith("/")) {
                                throw new AssertionError();
                            }
                            try {
                                channel.put(file.toString(), (String)remoteFile, progressMonitor, mode);
                            }
                            catch (SftpException e) {
                                throw new IOException(e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            try {
                                channel.mkdir(remotePath + "/" + String.valueOf(source.relativize(dir)));
                            }
                            catch (SftpException e) {
                                throw new IOException(e);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    if (e.getCause() instanceof SftpException) {
                        throw (SftpException)e.getCause();
                    }
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public @Nullable String realpath(@NonNull String remotePath) throws SftpException {
                return channel.realpath(remotePath);
            }

            private void getRecursive(@NonNull File targetDir, @NonNull String remotePath, @NonNull SftpProgressMonitor progressMonitor, int mode) throws SftpException, IOException {
                if (!targetDir.mkdirs() && !targetDir.isDirectory()) {
                    throw new IOException();
                }
                Vector children = channel.ls(remotePath);
                for (ChannelSftp.LsEntry child : children) {
                    File childFile = new File(targetDir, child.getFilename());
                    String remoteChildPath = String.format("%s/%s", remotePath, child.getFilename());
                    if (".".equals(child.getFilename()) || "..".equals(child.getFilename())) continue;
                    if (child.getAttrs().isDir()) {
                        this.getRecursive(childFile, remoteChildPath, progressMonitor, mode);
                        continue;
                    }
                    if (!child.getAttrs().isReg() && !child.getAttrs().isLink()) continue;
                    channel.get(remoteChildPath, childFile.getAbsolutePath(), progressMonitor, mode);
                }
            }
        };
    }

    public void connect() throws JSchException;

    public void disconnect();

    public @NonNull File get(boolean var1, @NonNull String var2, @NonNull String var3, @NonNull SftpProgressMonitor var4, int var5) throws SftpException, IOException;

    public @Nullable String getHome() throws SftpException;

    public void put(@NonNull String var1, @NonNull String var2, @NonNull SftpProgressMonitor var3, int var4) throws SftpException;

    public @Nullable String realpath(@NonNull String var1) throws SftpException;
}

