/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.IDeviceConnection;
import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.ITerminalWrapperCommandRunner;
import com.arm.streamline.deviceconn.lib.TerminalWrapperCommandRunner;
import com.arm.streamline.deviceconn.lib.TerminalWrapperConstants;
import com.arm.streamline.deviceconn.lib.TerminalWrapperDecoderInteractiveCommandAdapter;
import com.arm.streamline.deviceconn.ssh.BasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.IBasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.deviceconn.ssh.jsch.IJSch;
import com.arm.utils.function.IThrowingBiPredicate;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingPredicate;
import com.arm.utils.function.IThrowingSupplier;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import gnu.trove.map.TIntIntMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SshDeviceConnection
implements IDeviceConnection<ISshCommandRunner>,
ISshCommandRunner {
    private final @NonNull IBasicSshDeviceConnection connection;
    private final @NonNull String terminalWrapperCommand;
    private final @NonNull ITerminalWrapperCommandRunner<IBasicSshDeviceConnection.WrapMode> terminalWrapperCommandRunner;

    public SshDeviceConnection(@NonNull SshDeviceConfiguration configuration, @Nullable File logDirectory, @NonNull TIntIntMap portsToForward) throws JSchException, IOException {
        this.connection = new BasicSshDeviceConnection(configuration.create(IJSch.wrap(new JSch())), logDirectory, portsToForward);
        this.terminalWrapperCommandRunner = new TerminalWrapperCommandRunner<IBasicSshDeviceConnection.WrapMode, IProcessInteractiveCommand>((wrapMode, command, arguments) -> this.runWrappedCommand((IBasicSshDeviceConnection.WrapMode)((Object)wrapMode), command, arguments), (wrapMode, command) -> this.makeKiller((IBasicSshDeviceConnection.WrapMode)((Object)wrapMode), command));
        this.terminalWrapperCommand = String.format("%s/.sl.terminal_wrapper", this.connection.getUserHome());
        if (!TerminalWrapperConstants.pushTerminalWrapper(this.terminalWrapperCommand, (IThrowingSupplier<IBasicInteractiveShell.InteractiveCommandResult, IOException>)((IThrowingSupplier)() -> this.connection.runCommandAndGetOutput(IBasicSshDeviceConnection.WrapMode.DEFAULT, "uname", "-m")), (IThrowingFunction<File, String, IOException>)((IThrowingFunction)this::pushAsTempFile), (IThrowingPredicate<String, IOException>)((IThrowingPredicate)d -> this.connection.runCommandAndGetOutput((IBasicSshDeviceConnection.WrapMode)IBasicSshDeviceConnection.WrapMode.DEFAULT, (String)"chmod", (String[])new String[]{"755", d}).status.isSuccessful()), (IThrowingBiPredicate<String, String, IOException>)((IThrowingBiPredicate)(t, d) -> this.connection.runCommandAndGetOutput((IBasicSshDeviceConnection.WrapMode)IBasicSshDeviceConnection.WrapMode.DEFAULT, (String)"mv", (String[])new String[]{t, d}).status.isSuccessful()))) {
            throw new IOException("Failed to setup terminal wrapper");
        }
    }

    SshDeviceConnection(@NonNull IBasicSshDeviceConnection connection, @NonNull ITerminalWrapperCommandRunner<IBasicSshDeviceConnection.WrapMode> terminalWrapperCommandRunner, @NonNull String terminalWrapperCommand) throws JSchException, IOException {
        this.connection = connection;
        this.terminalWrapperCommandRunner = terminalWrapperCommandRunner;
        this.terminalWrapperCommand = terminalWrapperCommand;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public @NonNull ISshCommandRunner getInteractiveShell() {
        return this;
    }

    @Override
    public @NonNull String getUserHome() throws IOException {
        return this.connection.getUserHome();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runCommandAndGetOutput(IBasicSshDeviceConnection.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runCommandAsync(IBasicSshDeviceConnection.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull IInteractiveCommand runInteractiveCommand(@NonNull String command, String ... arguments) throws IOException {
        return this.terminalWrapperCommandRunner.runInteractiveCommand(IBasicSshDeviceConnection.WrapMode.DEFAULT, command, arguments);
    }

    @Override
    public @NonNull File scpPull(boolean recursive, @NonNull File localFile, @NonNull String remotePath) throws IOException {
        return this.connection.scpPull(recursive, localFile, remotePath);
    }

    @Override
    public @NonNull String scpPush(@NonNull File localFile, @NonNull String remotePath) throws IOException {
        return this.connection.scpPush(localFile, remotePath);
    }

    private @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller makeKiller(final @NonNull IBasicSshDeviceConnection.WrapMode wrapMode, final @NonNull IProcessInteractiveCommand command) {
        return new TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller(){

            @Override
            public void interrupt(int pid) throws Exception {
                if (pid == 0) {
                    command.interrupt();
                } else {
                    SshDeviceConnection.this.connection.runCommandAndGetOutput(wrapMode, "kill", Integer.toString(pid));
                }
            }

            @Override
            public void kill(int pid) throws Exception {
                if (pid == 0) {
                    command.kill();
                } else {
                    SshDeviceConnection.this.connection.runCommandAndGetOutput(wrapMode, "kill", "-9", Integer.toString(-pid));
                    SshDeviceConnection.this.connection.runCommandAndGetOutput(wrapMode, "kill", "-9", Integer.toString(pid));
                }
            }
        };
    }

    private @Nullable String pushAsTempFile(@NonNull File localFile) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult tempPath = this.connection.runCommandAndGetOutput(IBasicSshDeviceConnection.WrapMode.DEFAULT, "mktemp", "-q");
        if (!tempPath.status.isSuccessful()) {
            return null;
        }
        if (tempPath.output.size() != 1) {
            return null;
        }
        return this.scpPush(localFile, tempPath.output.get(0));
    }

    private @NonNull IProcessInteractiveCommand runWrappedCommand(@NonNull IBasicSshDeviceConnection.WrapMode wrapMode, @NonNull String command, @NonNull String @NonNull [] arguments) throws IOException {
        String[] commandAndArgs = new String[arguments.length + 1];
        commandAndArgs[0] = command;
        System.arraycopy(arguments, 0, commandAndArgs, 1, arguments.length);
        return this.connection.runInteractiveCommand(wrapMode, this.terminalWrapperCommand, commandAndArgs);
    }
}

