/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.ssh.jsch.IJSch;
import com.arm.streamline.deviceconn.ssh.jsch.ISession;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SshDeviceConfiguration {
    public static final int PORT = 22;
    private final @NonNull String hostname;
    private final @NonNull IJSchUpdater jschUpdater;
    private final int port;
    private final @NonNull UserInfo userInfo;
    private final @NonNull String username;

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull File keyfile, @Nullable String passphrase) throws JSchException, FileNotFoundException {
        this(hostname, port, username, new IdentityUserInfo(keyfile, passphrase));
    }

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull IConfigurationUserInfo userInfo) throws JSchException {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.userInfo = userInfo;
        this.jschUpdater = userInfo;
    }

    public SshDeviceConfiguration(@NonNull String hostname, int port, @NonNull String username, @NonNull String password) throws JSchException {
        this(hostname, port, username, new PasswordUserInfo(password));
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull File keyfile, @Nullable String passphrase) throws JSchException, FileNotFoundException {
        this(hostname, 22, username, keyfile, passphrase);
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull IConfigurationUserInfo userInfo) throws JSchException {
        this(hostname, 22, username, userInfo);
    }

    public SshDeviceConfiguration(@NonNull String hostname, @NonNull String username, @NonNull String password) throws JSchException {
        this(hostname, 22, username, password);
    }

    public @NonNull ISession create(@NonNull IJSch jsch) throws JSchException {
        this.jschUpdater.updateJSch(jsch);
        ISession session = (ISession)NullChecking.neverNull((Object)jsch.getSession(this.username, this.hostname, this.port));
        session.setUserInfo(this.userInfo);
        return session;
    }

    public boolean isRoot() {
        return "root".contentEquals(this.username);
    }

    public static interface IConfigurationUserInfo
    extends UserInfo,
    IJSchUpdater {
    }

    @FunctionalInterface
    public static interface IJSchUpdater {
        public void updateJSch(@NonNull IJSch var1) throws JSchException;
    }

    private static final class IdentityUserInfo
    implements IConfigurationUserInfo {
        private final @NonNull File keyfile;
        private final @Nullable String passphrase;

        public IdentityUserInfo(@NonNull File keyfile, @Nullable String passphrase) throws FileNotFoundException {
            if (!keyfile.isFile()) {
                throw new FileNotFoundException();
            }
            this.keyfile = keyfile;
            this.passphrase = passphrase;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            throw new AssertionError();
        }

        public boolean promptPassphrase(String message) {
            return this.passphrase != null;
        }

        public boolean promptPassword(String message) {
            return false;
        }

        public boolean promptYesNo(String message) {
            return true;
        }

        public void showMessage(String message) {
        }

        @Override
        public void updateJSch(@NonNull IJSch jsch) throws JSchException {
            jsch.addIdentity(FileUtils.canonicalisePath((File)this.keyfile));
        }
    }

    private static final class PasswordUserInfo
    implements IConfigurationUserInfo {
        private final @NonNull String password;

        public PasswordUserInfo(@NonNull String password) {
            this.password = password;
        }

        public String getPassphrase() {
            throw new AssertionError();
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String message) {
            return false;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return true;
        }

        public void showMessage(String message) {
        }

        @Override
        public void updateJSch(@NonNull IJSch jsch) {
        }
    }
}

