/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.ITerminalWrapperCommandRunner;
import com.arm.streamline.deviceconn.lib.TerminalWrapperDecoderInteractiveCommandAdapter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TerminalWrapperCommandRunner<M, T extends IProcessInteractiveCommand>
implements ITerminalWrapperCommandRunner<M> {
    private final @NonNull ICommandAdapter<M, T> commandAdapter;
    private final @NonNull ICommandRunner<M, T> commandRunner;

    public static <M, T extends IProcessInteractiveCommand> @NonNull ICommandAdapter<M, T> makeDefaultAdapter(@NonNull ICommandKillerFactory<M, T> commandKillerFactory) {
        return (c, wrapMode, of) -> new TerminalWrapperDecoderInteractiveCommandAdapter(c, of != null, false, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)(of != null ? of : () -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER), commandKillerFactory.makeKiller(wrapMode, c));
    }

    public TerminalWrapperCommandRunner(@NonNull ICommandRunner<M, T> commandRunner, @NonNull ICommandAdapter<M, T> commandAdapter) {
        this.commandAdapter = commandAdapter;
        this.commandRunner = commandRunner;
    }

    public TerminalWrapperCommandRunner(@NonNull ICommandRunner<M, T> commandRunner, @NonNull ICommandKillerFactory<M, T> commandKillerFactory) {
        this(commandRunner, TerminalWrapperCommandRunner.makeDefaultAdapter(commandKillerFactory));
    }

    @Override
    public IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull M wrapMode, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommand(wrapMode, command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull M wrapMode, IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult;
            IProcessInteractiveCommand interactiveCommand;
            T processInteractiveCommand;
            block16: {
                block15: {
                    processInteractiveCommand = this.commandRunner.runInteractiveCommand(wrapMode, command, arguments);
                    interactiveCommand = this.commandAdapter.adapt(processInteractiveCommand, wrapMode, stdOutConsumerFactory);
                    @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                    @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                    interactiveCommandResult = new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                    if (interactiveCommand == null) break block15;
                    interactiveCommand.close();
                }
                if (processInteractiveCommand == null) break block16;
                processInteractiveCommand.close();
            }
            return interactiveCommandResult;
            {
                catch (Throwable throwable2) {
                    try {
                        if (interactiveCommand != null) {
                            interactiveCommand.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (processInteractiveCommand != null) {
                            processInteractiveCommand.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public AsyncCommandFuture runCommandAsync(final @NonNull M wrapMode, final @NonNull String command, final String ... arguments) throws IOException {
        return new AsyncCommandFuture(new AsyncCommandFuture.IAsyncCommandFutureHelper(){
            private final @NonNull AtomicReference<@Nullable IProcessInteractiveCommand> interactiveCommandRef = new AtomicReference();

            @Override
            public void interrupt(boolean terminate) throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.interrupt();
                }
            }

            @Override
            public void kill() throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.kill();
                }
            }

            @Override
            public @NonNull String name() {
                return command;
            }

            /*
             * Loose catch block
             */
            @Override
            public @NonNull IBasicInteractiveShell.InteractiveCommandResult waitForResult() throws IOException {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult;
                    IProcessInteractiveCommand interactiveCommand;
                    Object processInteractiveCommand;
                    block16: {
                        block15: {
                            processInteractiveCommand = TerminalWrapperCommandRunner.this.commandRunner.runInteractiveCommand(wrapMode, command, arguments);
                            interactiveCommand = TerminalWrapperCommandRunner.this.commandAdapter.adapt(processInteractiveCommand, wrapMode, null);
                            this.interactiveCommandRef.set(interactiveCommand);
                            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                            interactiveCommandResult = new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                            if (interactiveCommand == null) break block15;
                            interactiveCommand.close();
                        }
                        if (processInteractiveCommand == null) break block16;
                        processInteractiveCommand.close();
                    }
                    return interactiveCommandResult;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (interactiveCommand != null) {
                                    interactiveCommand.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (processInteractiveCommand != null) {
                                    processInteractiveCommand.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        });
    }

    @Override
    public IProcessInteractiveCommand runInteractiveCommand(@NonNull M wrapMode, @NonNull String command, String ... arguments) throws IOException {
        return this.commandAdapter.adapt(this.commandRunner.runInteractiveCommand(wrapMode, command, arguments), wrapMode, null);
    }

    @FunctionalInterface
    public static interface ICommandAdapter<M, T extends IProcessInteractiveCommand> {
        public @NonNull IProcessInteractiveCommand adapt(@NonNull T var1, @NonNull M var2, @Nullable IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> var3) throws IOException;
    }

    @FunctionalInterface
    public static interface ICommandKillerFactory<M, T extends IProcessInteractiveCommand> {
        public @NonNull TerminalWrapperDecoderInteractiveCommandAdapter.IRemoteKiller makeKiller(@NonNull M var1, @NonNull T var2);
    }

    @FunctionalInterface
    public static interface ICommandRunner<M, T extends IProcessInteractiveCommand> {
        public @NonNull T runInteractiveCommand(@NonNull M var1, @NonNull String var2, String ... var3) throws IOException;
    }
}

