/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.ITerminalConnection;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.AsyncInputStreamLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.IProcess;
import com.arm.streamline.deviceconn.lib.IProcessCommandRunner;
import com.arm.streamline.deviceconn.lib.IProcessFactory;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.LineBuffer;
import com.arm.streamline.deviceconn.lib.LogDirectory;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProcessCommandRunner
implements IProcessCommandRunner {
    private final @NonNull LogDirectory logDirectory;
    private final @NonNull IProcessFactory processFactory;
    private final @NonNull File workingDirectory;

    private static @NonNull List<@NonNull String> makeCommandAndArguments(@NonNull String command, String ... arguments) {
        @NonNull ArrayList<@NonNull String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(command);
        commandAndArgs.addAll(Arrays.asList(arguments));
        if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_COMMAND_TO_SCREEN) {
            System.out.printf("%n%n[CMD]: %s%n%n", commandAndArgs.stream().collect(Collectors.joining(" ")));
        }
        return commandAndArgs;
    }

    public ProcessCommandRunner(@NonNull File workingDirectory, @Nullable File logDirectory) {
        this(IProcessFactory.usingProcessBuilder(), workingDirectory, logDirectory);
    }

    ProcessCommandRunner(@NonNull IProcessFactory processFactory, @NonNull File workingDirectory, @Nullable File logDirectory) {
        this.processFactory = processFactory;
        this.workingDirectory = workingDirectory;
        this.logDirectory = new LogDirectory(logDirectory);
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommand(command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandWithTimeoutAndGetOutput(long timeout, @NonNull TimeUnit unit, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var7_7 = null;
        try (@NonNull IProcessInteractiveCommand processInteractiveCommand = this.runInteractiveCommand(command, arguments);){
            @NonNull List<@NonNull String> lines = ((InteractiveCommand)processInteractiveCommand).collectAllRemainingOutputAndWaitForExitTimeout(timeout, unit);
            @Nullable List<@NonNull String> errorLines = processInteractiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)processInteractiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull AsyncCommandFuture runCommandAsync(final @NonNull String command, final String ... arguments) throws IOException {
        return new AsyncCommandFuture(new AsyncCommandFuture.IAsyncCommandFutureHelper(){
            private final @NonNull AtomicReference<@Nullable IProcessInteractiveCommand> interactiveCommandRef = new AtomicReference();

            @Override
            public void interrupt(boolean terminate) throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.interrupt();
                }
            }

            @Override
            public void kill() throws Exception {
                IProcessInteractiveCommand interactiveCommand = this.interactiveCommandRef.get();
                if (interactiveCommand != null) {
                    interactiveCommand.kill();
                }
            }

            @Override
            public @NonNull String name() {
                return command;
            }

            @Override
            public @NonNull IBasicInteractiveShell.InteractiveCommandResult waitForResult() throws IOException {
                Throwable throwable = null;
                Object var2_3 = null;
                try (IProcessInteractiveCommand interactiveCommand = ProcessCommandRunner.this.runInteractiveCommand(ProcessCommandRunner.makeCommandAndArguments(command, arguments));){
                    this.interactiveCommandRef.set(interactiveCommand);
                    @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
                    @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
                    return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandWithEnvAndGetOutput(@NonNull Map<@NonNull String, @NonNull String> env, @NonNull List<@NonNull String> commandAndArgs, boolean discardStdOutLines, boolean discardStdErrLines, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdErrConsumerFactory) throws IOException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommandWithEnv(env, commandAndArgs, discardStdOutLines, discardStdErrLines, stdOutConsumerFactory, stdErrConsumerFactory);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandWithEnvAndGetOutput(@NonNull Map<@NonNull String, @NonNull String> env, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull IProcessInteractiveCommand interactiveCommand = this.runInteractiveCommandWithEnv(env, command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull List<@NonNull String> commandAndArgs) throws IOException {
        return this.runInteractiveCommandWithEnv(Collections.emptyMap(), commandAndArgs);
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull String command, String ... arguments) throws IOException {
        return this.runInteractiveCommand(ProcessCommandRunner.makeCommandAndArguments(command, arguments));
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommandWithEnv(@NonNull Map<@NonNull String, @NonNull String> env, @NonNull List<@NonNull String> commandAndArgs) throws IOException {
        if (commandAndArgs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        @Nullable Pair<@NonNull File, @NonNull File> logFiles = this.logDirectory.get(commandAndArgs);
        File stdOutLog = logFiles != null ? (File)logFiles.first : null;
        File stdErrLog = logFiles != null ? (File)logFiles.second : null;
        return this.runInteractiveCommandWithEnv(env, commandAndArgs, false, false, AbstractAsyncByteReaderLineReaderAndLogger.createLogFileOutputStreamFactory(stdOutLog), AbstractAsyncByteReaderLineReaderAndLogger.createLogFileOutputStreamFactory(stdErrLog));
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommandWithEnv(@NonNull Map<@NonNull String, @NonNull String> env, @NonNull List<@NonNull String> commandAndArgs, boolean discardStdOutLines, boolean discardStdErrLines, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdErrConsumerFactory) throws IOException {
        if (commandAndArgs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        @NonNull IProcess process = this.processFactory.create(commandAndArgs.toArray(new String[commandAndArgs.size()]), this.workingDirectory, env);
        try {
            return new InteractiveCommand(process, discardStdOutLines, discardStdErrLines, stdOutConsumerFactory, stdErrConsumerFactory);
        }
        catch (Throwable t) {
            block8: {
                try {
                    try {
                        Throwing.closeAll((Closeable[])new Closeable[]{process.getOutputStream(), process.getInputStream(), process.getErrorStream()});
                    }
                    catch (Throwable e) {
                        t.addSuppressed(e);
                        process.destroyForcibly();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    process.destroyForcibly();
                    throw throwable;
                }
                process.destroyForcibly();
            }
            throw t;
        }
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommandWithEnv(@NonNull Map<@NonNull String, @NonNull String> env, @NonNull String command, String ... args) throws IOException {
        return this.runInteractiveCommandWithEnv(env, ProcessCommandRunner.makeCommandAndArguments(command, args));
    }

    private static final class InteractiveCommand
    implements IProcessInteractiveCommand {
        private static final int STATUS_TIMED_OUT = 124;
        private final @NonNull IProcess process;
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdErr;
        private final @NonNull OutputStream processStdIn;
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdOut;
        private final @NonNull LineBuffer stdErrBuffer = new LineBuffer();
        private final @NonNull LineBuffer stdOutBuffer = new LineBuffer();

        private static @NonNull IBasicInteractiveShell.CommandStatus extractStatus(int exitCode) {
            if (Platform.isLinux() || Platform.isMacintosh()) {
                if (exitCode >= 0 && exitCode < 128) {
                    return IBasicInteractiveShell.CommandStatus.exited(exitCode);
                }
                if (exitCode >= 128 && exitCode < 256) {
                    return IBasicInteractiveShell.CommandStatus.signalled(exitCode - 128);
                }
                return IBasicInteractiveShell.CommandStatus.unknown(String.format("exitCode=%d", exitCode));
            }
            return IBasicInteractiveShell.CommandStatus.exited(exitCode);
        }

        public InteractiveCommand(@NonNull IProcess process, boolean discardStdOutLines, boolean discardStdErrLines, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumer, @NonNull IThrowingSupplier<@NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdErrConsumer) {
            this.process = process;
            this.processStdIn = process.getOutputStream();
            this.processStdOut = new AsyncInputStreamLineReaderAndLogger(Charset.defaultCharset(), process.getInputStream(), true, discardStdOutLines ? AbstractAsyncByteReaderLineReaderAndLogger.ILineConsumer.NULL_LINE_CONSUMER : this.stdOutBuffer, stdOutConsumer);
            this.processStdErr = new AsyncInputStreamLineReaderAndLogger(Charset.defaultCharset(), process.getErrorStream(), true, discardStdErrLines ? AbstractAsyncByteReaderLineReaderAndLogger.ILineConsumer.NULL_LINE_CONSUMER : this.stdErrBuffer, stdErrConsumer);
        }

        @Override
        public void close() throws IOException {
            try {
                this.waitForExit();
            }
            catch (Throwable throwable) {
                Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
                throw throwable;
            }
            Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
        }

        @Override
        public @NonNull List<@NonNull String> collectAllRemainingOutputAndWaitForExit() throws IOException {
            this.waitForExit();
            @NonNull List<@NonNull String> result = this.collectAllRemainingOutput();
            return result;
        }

        public @NonNull List<@NonNull String> collectAllRemainingOutputAndWaitForExitTimeout(long timeout, @NonNull TimeUnit unit) {
            try {
                this.waitForExitInterruptibleTimeout(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            @NonNull List<@NonNull String> result = this.collectAllRemainingOutput();
            return result;
        }

        private @NonNull List<@NonNull String> collectAllRemainingOutput() {
            ITerminalConnection.TerminalLine line;
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdOutBuffer.nextLine()) != null || this.processStdOut.isRunning() || this.processStdErr.isRunning()) {
                if (line != null) {
                    if (!line.complete) continue;
                    result.add(line.line);
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public @Nullable List<@NonNull String> getErrorLines() {
            ITerminalConnection.TerminalLine line;
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdErrBuffer.nextLine()) != null) {
                if (!line.complete) continue;
                result.add(line.line);
            }
            return result;
        }

        @Override
        public @Nullable IBasicInteractiveShell.CommandStatus getExitCode() {
            if (this.isConnected()) {
                return null;
            }
            return InteractiveCommand.extractStatus(this.process.exitValue());
        }

        @Override
        public void interrupt() throws Exception {
            this.process.destroy();
        }

        @Override
        public boolean isConnected() {
            return this.process.isAlive() || this.processStdOut.isRunning() || this.processStdErr.isRunning();
        }

        @Override
        public void kill() throws Exception {
            this.process.destroyForcibly();
        }

        @Override
        public @Nullable ITerminalConnection.TerminalLine nextLine() throws IOException {
            return this.stdOutBuffer.nextLine();
        }

        @Override
        public void send(@NonNull String text) throws IOException {
            this.processStdIn.write(text.getBytes());
            this.processStdIn.flush();
        }

        @Override
        public @NonNull IBasicInteractiveShell.CommandStatus waitForExitInterruptible() throws InterruptedException {
            int result = this.process.waitFor();
            while (this.isConnected()) {
                Thread.sleep(100L);
            }
            return InteractiveCommand.extractStatus(result);
        }

        public @NonNull IBasicInteractiveShell.CommandStatus waitForExitInterruptibleTimeout(long timeout, @NonNull TimeUnit unit) throws InterruptedException {
            boolean result = this.process.waitFor(timeout, unit);
            if (!result) {
                this.process.destroyForcibly();
            }
            while (this.isConnected()) {
                Thread.sleep(100L);
            }
            if (!result) {
                return InteractiveCommand.extractStatus(124);
            }
            return InteractiveCommand.extractStatus(this.process.exitValue());
        }
    }
}

