/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidPackageActivityManager {
    private static final @NonNull String AM = "am";
    private final @NonNull IAdbCommandRunner adbCommandRunner;

    public AndroidPackageActivityManager(@NonNull IAdbCommandRunner adbCommandRunner) {
        this.adbCommandRunner = adbCommandRunner;
    }

    public void start(@NonNull String packageName, @NonNull String activityName) throws IOException {
        String packageActivity = String.format("%s/%s", packageName, activityName);
        IBasicInteractiveShell.InteractiveCommandResult result = this.adbCommandRunner.runCommandAndGetOutput(AM, "start-activity", packageActivity);
        if (result.errors != null && result.errors.size() > 0) {
            throw new IOException(String.format("Failed to start %s:\n%s", packageActivity, result.errorsAndOutputJoined()));
        }
    }

    public @NonNull Future<@NonNull Boolean> deferedStart(long delayMillis, @NonNull String packageName, @NonNull String activityName, @Nullable Function<@NonNull Boolean, @NonNull Boolean> callback) {
        return AsyncCommandFuture.ASYNC_CMD_EXECUTOR.submit(() -> {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.start(packageName, activityName);
            Boolean result = this.isActivityStarted(packageName);
            if (callback == null) {
                return result;
            }
            return (Boolean)callback.apply(result);
        });
    }

    public void stop(@NonNull String packageName) throws IOException {
        this.adbCommandRunner.runCommandAndGetOutput(AM, "force-stop", packageName);
    }

    public boolean isActivityStarted(@NonNull String packageName) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult result = this.adbCommandRunner.runCommandAndGetOutput("pidof", packageName);
        return result.output.size() == 1;
    }
}

