/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb.utils;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.adb.utils.AdbInstalledPackage;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class AdbPackageEnumeration {
    private static final @NonNull Pattern PM_LIST_PACKAGE_PATTERN = Pattern.compile("package:(.+)=(.+)");
    private static final @NonNull Pattern PM_PATH_PATTERN = Pattern.compile("package:(.+)");
    private static final @NonNull Pattern DEBUGGABLE_PKG_LIST_PATTERN = Pattern.compile("^.*\\[(.*)\\].*$");
    private static final @NonNull Pattern DUMPSYS_PACKAGE_PATTERN = Pattern.compile("^(.*)/(.*)$");
    private final @NonNull IAdbCommandRunner adbRunner;
    private final @NonNull BooleanSupplier cancelledSupplier;

    private static @NonNull List<@NonNull String> parseDumpsysPackageOutput(@NonNull List<@NonNull String> dumpsysOutput) {
        String line;
        String concatString = String.join((CharSequence)"\n", dumpsysOutput);
        Object modifiedStr = "\n";
        ArrayList<String> result = new ArrayList<String>();
        concatString = concatString.replace("\n        ", " ");
        String[] stringArray = concatString.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            if (line.contains("android.intent.action.MAIN:")) {
                modifiedStr = (String)modifiedStr + line + "\n";
            }
            ++n2;
        }
        modifiedStr = ((String)modifiedStr).replace(" ", "\n");
        stringArray = ((String)modifiedStr).split("\n");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            if (line.contains("/")) {
                result.add(line);
            }
            ++n2;
        }
        Collections.sort(result);
        return result;
    }

    public static final @NonNull Set<@NonNull AdbInstalledPackage> enumerate(@NonNull IAdbCommandRunner adbRunner, boolean only3rdPartyDebuggable, @NonNull BooleanSupplier cancelledSupplier) throws IOException {
        AdbPackageEnumeration e = new AdbPackageEnumeration(adbRunner, cancelledSupplier);
        return e.enumerate(only3rdPartyDebuggable);
    }

    public static final @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> enumerateAsync(@NonNull IAdbCommandRunner adbRunner, boolean only3rdPartyDebuggable, @NonNull BooleanSupplier cancelledSupplier) throws IOException {
        AdbPackageEnumeration e = new AdbPackageEnumeration(adbRunner, cancelledSupplier);
        return e.enumerateAsync(only3rdPartyDebuggable);
    }

    private static @NonNull Map<@NonNull String, @NonNull String> parseListPackagesOutput(@NonNull List<@NonNull String> outputLines) {
        @NonNull HashMap<@NonNull String, @NonNull String> packages = new HashMap<String, String>();
        for (String line : outputLines) {
            Matcher m = PM_LIST_PACKAGE_PATTERN.matcher(line);
            if (!m.matches()) continue;
            packages.put((String)NullChecking.neverNull((Object)m.group(1)), (String)NullChecking.neverNull((Object)m.group(2)));
        }
        return packages;
    }

    public AdbPackageEnumeration(@NonNull IAdbCommandRunner adbRunner, @NonNull BooleanSupplier cancelledSupplier) {
        this.adbRunner = adbRunner;
        this.cancelledSupplier = cancelledSupplier;
    }

    public final @NonNull Set<@NonNull AdbInstalledPackage> enumerate(boolean only3rdPartyDebuggable) throws IOException {
        return this.getInstalledPackages(only3rdPartyDebuggable);
    }

    public final @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> enumerateAsync(boolean only3rdPartyDebuggable) throws IOException {
        return this.getInstalledPackagesAsync(only3rdPartyDebuggable);
    }

    private static @NonNull AdbInstalledPackage createADBInstalledPackage(@NonNull String location, @NonNull String name, @NonNull Map<@NonNull String, Pair<@NonNull Set<@NonNull String>, Boolean>> packagesInfoMap) {
        Pair<Set<String>, Boolean> valuePair;
        @NonNull Set<@NonNull String> activities = new HashSet<String>();
        boolean debuggable = true;
        if (packagesInfoMap.containsKey(name) && (valuePair = packagesInfoMap.get(name)) != null) {
            activities = (Set)valuePair.first;
            debuggable = (Boolean)valuePair.second;
        }
        return new AdbInstalledPackage(location, name, activities, debuggable);
    }

    private @NonNull Set<@NonNull AdbInstalledPackage> getInstalledPackages(boolean only3rdPartyDebuggable) throws IOException {
        Pair<Integer, Stream<AdbInstalledPackage>> result = this.getInstalledPackagesAsync(only3rdPartyDebuggable);
        return ((Stream)result.second).collect(Collectors.toSet());
    }

    private @NonNull List<@NonNull String> getDebuggablePkgsList() throws IOException {
        ArrayList<String> resultList = new ArrayList<String>();
        String cmd = "dumpsys package p | sed 's/ //g' | grep -E '^Package|^flags=\\[.*DEBUGGABLE.*\\]' | grep -B1 'DEBUGGABLE' | grep -E '^Package\\['";
        IBasicInteractiveShell.InteractiveCommandResult completedProcess = this.adbRunner.runCommandAndGetOutput("sh", "-c", cmd);
        if (completedProcess.errors != null && completedProcess.errors.size() > 0) {
            throw new AdbCommandIOException(cmd, completedProcess);
        }
        for (String line : completedProcess.output) {
            String pkg;
            Matcher matcher = DEBUGGABLE_PKG_LIST_PATTERN.matcher(line);
            if (!matcher.matches() || (pkg = matcher.group(1)) == null) continue;
            resultList.add(pkg);
        }
        return resultList;
    }

    private @NonNull Map<@NonNull String, Pair<@NonNull Set<@NonNull String>, Boolean>> getInfoForAllPackages() throws IOException {
        List<String> cmdOutput;
        HashMap<String, Pair<Set<String>, Boolean>> packageInfoMap = new HashMap<String, Pair<Set<String>, Boolean>>();
        List<String> debuggablePackages = this.getDebuggablePkgsList();
        String cmd = "dumpsys package r | sed -z 's/\\n        / /g' | grep 'android.intent.action.MAIN:' | tr ' ' '\\n'  | grep '/' | sort | uniq";
        IBasicInteractiveShell.InteractiveCommandResult completedProcess = this.adbRunner.runCommandAndGetOutput("sh", "-c", cmd);
        List<String> errors = completedProcess.errors;
        if (!completedProcess.status.isSuccessful() || errors != null && errors.size() > 0) {
            cmd = "dumpsys package r";
            completedProcess = this.adbRunner.runCommandAndGetOutput("sh", "-c", cmd);
            if (!completedProcess.status.isSuccessful()) {
                throw new AdbCommandIOException(cmd, completedProcess);
            }
            cmdOutput = AdbPackageEnumeration.parseDumpsysPackageOutput(completedProcess.output);
        } else {
            cmdOutput = completedProcess.output;
        }
        for (String line : cmdOutput) {
            Pair<Set<String>, Boolean> valuePair;
            Matcher matcher = DUMPSYS_PACKAGE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            String pkg = matcher.group(1);
            String activity = matcher.group(2);
            if (pkg == null || activity == null) continue;
            if (!packageInfoMap.containsKey(pkg)) {
                packageInfoMap.put(pkg, (Pair<Set<String>, Boolean>)new Pair(new HashSet(), (Object)debuggablePackages.contains(pkg)));
            }
            if ((valuePair = packageInfoMap.get(pkg)) == null) continue;
            ((Set)valuePair.first).add(activity);
        }
        return packageInfoMap;
    }

    private @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> getInstalledPackagesAsync(boolean only3rdPartyDebuggable) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult completedProcess;
        IBasicInteractiveShell.InteractiveCommandResult interactiveCommandResult = completedProcess = only3rdPartyDebuggable ? this.adbRunner.runCommandAndGetOutput("pm", "list", "packages", "-e", "-f", "-3") : this.adbRunner.runCommandAndGetOutput("pm", "list", "packages", "-e", "-f");
        if (!completedProcess.status.isSuccessful()) {
            throw new AdbCommandIOException("pm list packages -e -f" + (only3rdPartyDebuggable ? " -3" : ""), completedProcess);
        }
        if (this.isCancelled()) {
            return new Pair((Object)0, Stream.empty());
        }
        Map<String, String> packageInfo = AdbPackageEnumeration.parseListPackagesOutput(completedProcess.output);
        Map<String, Pair<Set<String>, Boolean>> packageActivityMap = this.getInfoForAllPackages();
        return new Pair((Object)packageInfo.size(), ((Stream)packageInfo.entrySet().parallelStream().unordered()).takeWhile(e -> !this.isCancelled()).filter(entry -> packageActivityMap.containsKey(entry.getValue())).map(entry -> AdbPackageEnumeration.createADBInstalledPackage((String)entry.getKey(), (String)entry.getValue(), packageActivityMap)));
    }

    private boolean isCancelled() {
        return this.cancelledSupplier.getAsBoolean();
    }

    public final @NonNull AdbInstalledPackage discoverSinglePackage(@NonNull String packageName) throws IOException, InvalidPackageException {
        IBasicInteractiveShell.InteractiveCommandResult result = this.adbRunner.runCommandAndGetOutput("pm", "path", packageName);
        if (!result.status.isSuccessful()) {
            if (result.errorsAndOutput().isEmpty()) {
                throw new InvalidPackageException(packageName);
            }
            throw new AdbCommandIOException("pm path " + packageName, result);
        }
        Matcher matcher = PM_PATH_PATTERN.matcher(result.errorsOrOutputJoined());
        if (!matcher.matches()) {
            throw new InvalidPackageException(packageName);
        }
        String location = (String)NullChecking.neverNull((Object)matcher.group(1));
        Map<String, Pair<Set<String>, Boolean>> packageActivityMap = this.getInfoForAllPackages();
        return AdbPackageEnumeration.createADBInstalledPackage(location, packageName, packageActivityMap);
    }

    public static class InvalidPackageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidPackageException(@NonNull String packageName) {
            super(MessageFormat.format("Package \"{0}\" not available on device", packageName));
        }
    }
}

