/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.ProcessCommandRunner;
import com.arm.utils.function.IThrowingSupplier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AdbProcessRunner
implements IAdbProcessRunner {
    static final int TIMEOUT = 1000;
    private final @NonNull File adbPath;
    private final @NonNull ProcessCommandRunner processCommandRunner;

    public static boolean isValidAdb(@Nullable String pathToAdb) {
        IAdbProcessRunner runner = null;
        try {
            runner = AdbProcessRunner.tryCreate(pathToAdb);
        }
        catch (IOException e) {
            return false;
        }
        return runner != null;
    }

    public static @Nullable IAdbProcessRunner tryCreate(@Nullable String pathToAdb) throws IOException {
        if (pathToAdb == null || pathToAdb.isEmpty()) {
            return null;
        }
        return new AdbProcessRunner(new File(pathToAdb));
    }

    public AdbProcessRunner(@NonNull File adbPath) throws IOException {
        this(adbPath, new File(System.getProperty("user.home")), null);
    }

    public AdbProcessRunner(@NonNull File adbPath, @NonNull File workingDirectory, @Nullable File logDirectory) throws IOException {
        boolean adbVersionUnsuccessful;
        if (!adbPath.isFile() || !adbPath.canExecute()) {
            throw new FileNotFoundException(adbPath.getAbsolutePath());
        }
        this.adbPath = adbPath;
        this.processCommandRunner = new ProcessCommandRunner(workingDirectory, logDirectory);
        IBasicInteractiveShell.InteractiveCommandResult versionResult = this.runCommandWithTimeoutAndGetOutput(1000L, TimeUnit.MILLISECONDS, "version");
        boolean invalidAdbVersionOutput = !versionResult.errorsAndOutputJoined().toLowerCase().contains("android debug bridge version");
        boolean bl = adbVersionUnsuccessful = !versionResult.status.isSuccessful();
        if (adbVersionUnsuccessful || invalidAdbVersionOutput) {
            throw new IOException("adb check with version option has failed with status: " + String.valueOf(versionResult.status) + ", output " + versionResult.errorsAndOutputJoined());
        }
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(String ... commandAndArgs) throws IOException {
        return this.processCommandRunner.runCommandAndGetOutput(this.adbPath.getAbsolutePath(), commandAndArgs);
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandWithTimeoutAndGetOutput(long timeout, @NonNull TimeUnit unit, String ... commandAndArgs) throws IOException {
        return this.processCommandRunner.runCommandWithTimeoutAndGetOutput(timeout, unit, this.adbPath.getAbsolutePath(), commandAndArgs);
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> stdOutConsumerFactory, String ... commandAndArgs) throws IOException {
        return this.processCommandRunner.runCommandWithEnvAndGetOutput(Collections.emptyMap(), Arrays.asList(commandAndArgs), true, false, stdOutConsumerFactory, (IThrowingSupplier<AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException>)((IThrowingSupplier)() -> AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer.NULL_BYTE_CONSUMER));
    }

    @Override
    public @NonNull IProcessInteractiveCommand runInteractiveCommand(String ... commandAndArgs) throws IOException {
        return this.processCommandRunner.runInteractiveCommand(this.adbPath.getAbsolutePath(), commandAndArgs);
    }
}

