/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn;

import com.arm.streamline.deviceconn.IInteractiveCommand;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IBasicInteractiveShell {
    public @NonNull InteractiveCommandResult runCommandAndGetOutput(@NonNull String var1, String ... var2) throws IOException;

    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull String var1, String ... var2) throws IOException;

    public @NonNull IInteractiveCommand runInteractiveCommand(@NonNull String var1, String ... var2) throws IOException;

    public static final class CommandStatus {
        private final @NonNull String message;
        private final @NonNull Type type;
        private final int value;

        public static @NonNull CommandStatus exception(@NonNull Throwable t) {
            String className = t.getClass().getSimpleName();
            String message = t.getMessage();
            return new CommandStatus(Type.EXCEPTION, 0, String.format("type '%s' thrown%s", className, message != null ? String.format(", with message '%s'", message) : ""));
        }

        public static @NonNull CommandStatus execFailed(@NonNull String message) {
            return new CommandStatus(Type.EXEC_FAILED, 0, message);
        }

        public static @NonNull CommandStatus exited(byte exitCode) {
            return CommandStatus.exited(Byte.toUnsignedInt(exitCode));
        }

        public static @NonNull CommandStatus exited(int exitCode) {
            return new CommandStatus(Type.EXITED, exitCode, "");
        }

        public static @NonNull CommandStatus exitedUnknownCode(@NonNull String message) {
            return new CommandStatus(Type.EXITED_WITH_UNKNOWN_CODE, 0, message);
        }

        public static @NonNull CommandStatus signalled(byte signal) {
            return CommandStatus.signalled(Byte.toUnsignedInt(signal));
        }

        public static @NonNull CommandStatus signalled(int signal) {
            assert (signal >= 0);
            return new CommandStatus(Type.SIGNALLED, signal, "");
        }

        public static @NonNull CommandStatus unknown(@NonNull String message) {
            return new CommandStatus(Type.UNKNOWN, 0, message);
        }

        private CommandStatus(@NonNull Type type, int value, @NonNull String message) {
            this.type = type;
            this.value = value;
            this.message = message;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandStatus other = (CommandStatus)obj;
            if (!this.message.equals(other.message)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.value == other.value;
        }

        public int getExitCode() {
            if (this.type != Type.EXITED) {
                throw new IllegalStateException(this.toString());
            }
            return this.value;
        }

        public int getSignalNumber() {
            if (this.type == Type.SIGNALLED) {
                throw new IllegalStateException(this.toString());
            }
            return this.value;
        }

        public @NonNull Type getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.message.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.value;
            return result;
        }

        public boolean isFailedToExec() {
            return this.type == Type.EXEC_FAILED;
        }

        public boolean isSuccessful() {
            return this.type == Type.EXITED && this.value == 0;
        }

        public @NonNull String toString() {
            switch (this.type) {
                case EXITED: {
                    return "terminated normally with exit code " + this.value;
                }
                case EXITED_WITH_UNKNOWN_CODE: {
                    return "terminated normally with unknown exit code: " + this.message;
                }
                case SIGNALLED: {
                    return "terminated by signal " + this.value;
                }
                case EXEC_FAILED: {
                    return "exec failed: " + this.message;
                }
                case UNKNOWN: {
                    return "unknown: " + this.message;
                }
                case EXCEPTION: {
                    return "exception thrown: " + this.message;
                }
            }
            throw new AssertionError((Object)this.type);
        }

        public static enum Type {
            EXCEPTION,
            EXEC_FAILED,
            EXITED,
            EXITED_WITH_UNKNOWN_CODE,
            SIGNALLED,
            UNKNOWN;

        }
    }

    public static final class InteractiveCommandResult {
        public final @Nullable List<@NonNull String> errors;
        public final @NonNull List<@NonNull String> output;
        public final @NonNull CommandStatus status;

        public InteractiveCommandResult(@NonNull CommandStatus status, @NonNull List<@NonNull String> output, @Nullable List<@NonNull String> errors) {
            this.status = status;
            this.output = output;
            this.errors = errors;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InteractiveCommandResult) {
                InteractiveCommandResult that = (InteractiveCommandResult)obj;
                return this.status.equals(that.status) && this.output.equals(that.output) && NullChecking.equalsNullable(this.errors, that.errors);
            }
            return false;
        }

        public @NonNull List<@NonNull String> errorsAndOutput() {
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>(this.output);
            @Nullable List<@NonNull String> errors = this.errors;
            if (errors != null) {
                result.addAll(errors);
            }
            return result;
        }

        public @NonNull String errorsAndOutputJoined() {
            return Stream.concat(this.errors != null ? this.errors.stream() : Stream.empty(), this.output.stream()).collect(Collectors.joining("\n"));
        }

        public @NonNull List<@NonNull String> errorsOrOutput() {
            @Nullable List<@NonNull String> errors = this.errors;
            if (errors != null && !errors.isEmpty()) {
                return errors;
            }
            return this.output;
        }

        public @NonNull String errorsOrOutputJoined() {
            return this.errorsOrOutput().stream().collect(Collectors.joining("\n"));
        }

        public int hashCode() {
            return this.status.hashCode() * 31 + this.output.hashCode();
        }

        public boolean isErrorLogSeparateFromNormalOutput() {
            return this.errors != null;
        }

        public String toString() {
            return String.format("{%s, %s, %s}", this.status, this.output, this.errors);
        }
    }
}

