/*
 * Decompiled with CFR 0.152.
 */
package com.arm.compilermanager;

import com.arm.compilermanager.Compilers;
import com.arm.compilermanager.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class CompilerManager {
    private static String getFatJarOSArchPath() {
        String string;
        String string2;
        String string3 = System.getProperty("os.name").trim().toLowerCase();
        String string4 = System.getProperty("os.arch").trim().toLowerCase();
        String string5 = string2 = string4.contains("64") ? "x64" : "x86";
        String string6 = string3.contains("linux") ? "linux" : (string3.contains("win") ? "windows" : (string = string3.contains("mac") ? "mac" : null));
        if (string == null) {
            return null;
        }
        return string + "_" + string2;
    }

    private static native boolean initializeLibraries(String var0);

    private static native void releaseLibraries();

    public static native Version getManagerVersion();

    public static native Compilers getCompilers(String var0, String var1, String var2, String var3, String var4, int var5);

    public static native void releaseCompilers(Compilers var0);

    static {
        try {
            File file;
            Object object;
            String string = CompilerManager.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            File file2 = new File(string);
            String string2 = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
            String string3 = System.mapLibraryName("compiler_manager");
            if (string3.endsWith(".jnilib")) {
                string3 = string3.substring(0, string3.length() - ".jnilib".length());
                string3 = string3 + ".dylib";
            }
            File file3 = new File(string2);
            file3.mkdirs();
            file3.deleteOnExit();
            JarFile jarFile = new JarFile(file2);
            Object object2 = jarFile.entries();
            while (object2.hasMoreElements()) {
                int n;
                object = object2.nextElement();
                if (!((ZipEntry)object).getName().startsWith("bin/") || ((ZipEntry)object).isDirectory()) continue;
                file = new File(((ZipEntry)object).getName());
                String string4 = file.getPath().substring("bin/".length());
                File file4 = new File(file3, string4);
                File file5 = file4.getParentFile();
                file5.mkdirs();
                file5.deleteOnExit();
                file4.createNewFile();
                file4.deleteOnExit();
                InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
            jarFile.close();
            object2 = CompilerManager.getFatJarOSArchPath();
            object = object2 != null ? new File(file3, (String)object2) : null;
            file = null;
            if (object != null && ((File)object).exists() && ((File)object).isDirectory() && (!(file = new File((File)object, string3)).exists() || !file.isFile())) {
                file = null;
            }
            if (file == null) {
                file = new File(file3, string3);
            }
            if (!file.exists() || !file.isFile()) {
                throw new Exception("Could not find compiler_manager library! (osArchPath = " + (String)object2 + ", outputPath = " + file3 + ")");
            }
            file.setExecutable(true);
            System.load(file.getAbsolutePath());
            CompilerManager.initializeLibraries(file.getParentFile().getCanonicalPath());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CompilerManager.releaseLibraries();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

