/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.NullChecking;
import com.arm.utils.text.NumericStringComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class RowSorter<C extends Column<C>>
implements Comparator<Row<C>> {
    private final C[] mSortingOrder;

    public static <C extends Column<C>> @NonNull Set<Row<C>> collectContainerRows(@NonNull List<@NonNull Row<C>> rows, @NonNull Set<@NonNull Row<C>> containers) {
        for (Row<C> row : rows) {
            if (!row.canHaveChildren()) continue;
            containers.add(row);
            if (!row.hasChildren()) continue;
            RowSorter.collectContainerRows((List)NullChecking.neverNull(row.getChildren()), containers);
        }
        return containers;
    }

    public static <C extends Column<C>> void sort(@NonNull List<@NonNull C> columns, @NonNull List<@NonNull Row<C>> rows) {
        RowSorter.sort(columns, rows, false);
    }

    public static <C extends Column<C>> void sort(@NonNull List<@NonNull C> columns, @NonNull List<@NonNull Row<C>> rows, boolean internal) {
        for (Column column : columns) {
            if (column.getSortSequence() == -1) continue;
            RowSorter<C> rowSorter = new RowSorter<C>(columns);
            Collections.sort(rows, rowSorter);
            if (internal) {
                for (Row<C> row : RowSorter.collectContainerRows(rows, new HashSet<Row<C>>())) {
                    if (!row.hasChildren()) continue;
                    Collections.sort(row.getChildList(), rowSorter);
                }
            }
            return;
        }
    }

    private RowSorter(@NonNull List<@NonNull C> columns) {
        int count = columns.size();
        Column[] orig = new Column[count];
        Column[] sortingOrder = new Column[count];
        this.mSortingOrder = sortingOrder;
        int pos = -1;
        int i = 0;
        while (i < count) {
            Column column = (Column)columns.get(i);
            int order = column.getSortSequence();
            if (order >= 0 && order < count) {
                this.mSortingOrder[order] = column;
            } else {
                orig[i] = column;
                if (pos == -1) {
                    pos = i;
                }
            }
            ++i;
        }
        if (pos != -1) {
            i = 0;
            while (i < count) {
                if (this.mSortingOrder[i] == null) {
                    int current;
                    Column col;
                    if ((col = orig[current = pos++]) != null) {
                        @NonNull Collection<@NonNull C> requredByColumns = col.getRequredByColumns();
                        this.mSortingOrder[i] = !col.isVisible() && !requredByColumns.isEmpty() ? (Column)requredByColumns.stream().sorted((o1, o2) -> NumericStringComparator.caselessCompareStrings((String)o1.getSanitizedName(), (String)o2.getSanitizedName())).findFirst().get() : col;
                        if (i == 0 && col.getSortSequence() == -1) {
                            ((Column)this.mSortingOrder[i]).setSortCriteria(i, ((Column)this.mSortingOrder[i]).isSortAscending());
                        }
                    }
                    while (pos < count && orig[pos] == null) {
                        ++pos;
                    }
                    if (pos >= count) break;
                }
                ++i;
            }
        }
    }

    @Override
    public int compare(Row<C> rowOne, Row<C> rowTwo) {
        if (rowOne.getParent() == rowTwo.getParent()) {
            C[] CArray = this.mSortingOrder;
            int n = this.mSortingOrder.length;
            int n2 = 0;
            while (n2 < n) {
                Object column = CArray[n2];
                if (column == null) {
                    return 0;
                }
                int result = ((Column)column).getRowCell(null).compare(column, rowOne, rowTwo);
                if (result != 0) {
                    return ((Column)column).isSortAscending() ? result : -result;
                }
                ++n2;
            }
        } else {
            if (rowOne.isDescendentOf(rowTwo)) {
                return 1;
            }
            if (rowTwo.isDescendentOf(rowOne)) {
                return -1;
            }
            Row<C>[] oneParents = rowOne.getPath();
            Row<C>[] twoParents = rowTwo.getPath();
            int max = Math.min(oneParents.length, twoParents.length);
            int i = 0;
            while (i < max) {
                if (oneParents[i] != twoParents[i]) break;
                ++i;
            }
            return this.compare(oneParents[i], twoParents[i]);
        }
        return 0;
    }
}

