/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.BoxCell;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PercentageCell<C extends Column<C>>
implements ICell<C> {
    private static int textSpace;
    private int mMinimumBarWidth;
    private boolean mWholeNumbersOnly;
    private boolean mpercentageOnly;

    public static int getMinimumContentWidth(Font font, boolean wholeNumbersOnly) {
        return FontInfo.get((Font)font).getExtent((String)NumberUtils.formatPercentage((double)99.999, (boolean)wholeNumbersOnly)).x + 8;
    }

    public PercentageCell(boolean wholeNumbersOnly, boolean percentageOnly) {
        this(100, wholeNumbersOnly, percentageOnly);
    }

    public PercentageCell(int minimumBarWidth, boolean wholeNumbersOnly, boolean percentageOnly) {
        this.mMinimumBarWidth = minimumBarWidth;
        this.mWholeNumbersOnly = wholeNumbersOnly;
        this.mpercentageOnly = percentageOnly;
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        double p2;
        double p1 = this.getPercentage(one, column);
        if (p1 < (p2 = this.getPercentage(two, column))) {
            return -1;
        }
        if (p1 > p2) {
            return 1;
        }
        return 0;
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active) {
        if (!this.mpercentageOnly) {
            @Nullable PercentAndValue percentageAndValue = this.getPercentAndValue(row, column);
            long value = percentageAndValue != null ? percentageAndValue.value : 0L;
            double percentage = percentageAndValue != null ? percentageAndValue.percent : -1.0;
            PercentageCell.drawValueAndPercentage(gc, Fonts.getNormal(), bounds, value, percentage, this.mWholeNumbersOnly, selected, active);
        } else {
            PercentageCell.drawPercentage(gc, Fonts.getNormal(), bounds, this.getPercentage(row, column), this.mWholeNumbersOnly, selected, active);
        }
    }

    public @Nullable PercentAndValue getPercentAndValue(@NonNull Row<C> row, @NonNull C column) {
        double percent = this.getPercentage(row, column);
        return percent >= 0.0 ? new PercentAndValue(this.getValue(row, column), percent) : null;
    }

    public long getValue(@NonNull Row<C> row, @NonNull C column) {
        return row.getDataAsLong(column);
    }

    @Override
    public int getMinimumContentWidth() {
        return WorkspaceUtils.isHeadless() ? 0 : PercentageCell.getMinimumContentWidth(Fonts.getNormal(), this.mWholeNumbersOnly);
    }

    public double getPercentage(@NonNull Row<C> row, @NonNull C column) {
        return row.getDataAsDouble(column);
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Font font = Fonts.getNormal();
        Point size = FontInfo.get(font).getExtent(NumberUtils.formatPercentage((double)99.999, (boolean)this.mWholeNumbersOnly));
        size.x += this.mMinimumBarWidth + 12;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        return row.getToolTipText(column);
    }

    public static void drawValueAndPercentage(GC gc, Font font, Rectangle bounds, long sample, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active) {
        if (percentage >= 0.0) {
            FontInfo fi;
            gc.setFont(font);
            if (percentage > 100.0) {
                percentage = 100.0;
            }
            if ((fi = FontInfo.get(font)).getWidth(NumberUtils.format((long)sample)) > textSpace) {
                textSpace = fi.getWidth(NumberUtils.format((long)sample));
            }
            int leftMargin = textSpace + 8;
            int percentWidth = bounds.width - leftMargin;
            int width = fi.getWidth(NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly));
            int textAvailable = Math.min(textSpace, bounds.width);
            gc.setForeground(Colors.getText(selected && active));
            if (textAvailable > 0) {
                TextDrawing.drawString(gc, TextDrawing.truncateString(font, NumberUtils.format((long)sample), textAvailable, 131072), bounds.x + 4 + textAvailable - 1, bounds.y + (bounds.height - fi.getHeight()) / 2, 131072);
            }
            if (percentWidth > 0 && percentWidth > width) {
                double p = percentage;
                BoxCell.drawBoxAround(gc, new Rectangle(bounds.x + leftMargin, bounds.y, percentWidth, bounds.height), innerBounds -> {
                    PercentageCell.drawPercentageBar(gc, font, fi, wholeNumbersOnly, p, innerBounds);
                    return true;
                });
            }
        }
    }

    public static void drawPercentage(GC gc, Font font, Rectangle bounds, double percentage, boolean wholeNumbersOnly, boolean selected, boolean active) {
        if (percentage >= 0.0) {
            gc.setFont(font);
            if (percentage > 100.0) {
                percentage = 100.0;
            }
            FontInfo fi = FontInfo.get(font);
            int width = fi.getWidth(NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly));
            if (bounds.width > 0 && bounds.width > width) {
                double p = percentage;
                BoxCell.drawBorderAround(bounds, innerBounds -> {
                    gc.setForeground(Colors.getText(selected && active));
                    PercentageCell.drawPercentageBar(gc, font, fi, wholeNumbersOnly, p, innerBounds);
                });
            }
        }
    }

    private static void drawPercentageBar(GC gc, Font font, FontInfo fi, boolean wholeNumbersOnly, double percentage, @NonNull Rectangle innerBounds) {
        int left = innerBounds.x;
        int top = innerBounds.y;
        int width = innerBounds.width;
        int height = innerBounds.height;
        int textWidth = width - 8;
        if (width > 0 && height > 0) {
            Pattern gradient = new Pattern(gc.getDevice(), (float)left, 0.0f, (float)(left + width), 0.0f, Colors.getYellow(), Colors.getRed());
            gc.setBackgroundPattern(gradient);
            gc.fillRectangle(left, top, (int)((double)width * (percentage / 100.0)), height);
            gradient.dispose();
            if (textWidth > 0) {
                String truncateString = TextDrawing.truncateString(font, NumberUtils.formatPercentage((double)percentage, (boolean)wholeNumbersOnly), textWidth, 131072);
                int realTextWidth = fi.getWidth(truncateString);
                int textMargin = (width - realTextWidth) / 2 + realTextWidth;
                assert (realTextWidth <= textWidth);
                TextDrawing.drawString(gc, truncateString, left + textMargin, top + (height - fi.getHeight()) / 2, 131072);
            }
        }
    }
}

