/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.RowSorter;
import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class OutlineModel<C extends Column<C>>
implements IStdSelectionOwner {
    private final @NonNull List<IOutlineModelListener<C>> mListeners = new ArrayList<IOutlineModelListener<C>>();
    private final @NonNull List<@NonNull C> mColumns = new ArrayList<C>();
    private final @NonNull List<@NonNull Row<C>> mRows = new ArrayList<Row<C>>();
    private List<@NonNull Row<C>> mTopLevelRows;
    private final @NonNull Set<@NonNull Row<C>> mRowSet = new HashSet<Row<C>>();
    private TObjectIntHashMap<Row<C>> mRowIndexes;
    private final @NonNull StdSelection mSelection = new StdSelection(this);
    private boolean mNotifyOfSelections = true;
    private Row<C> mSavedAnchorRow;
    private @Nullable List<@NonNull Row<C>> mSavedSelection;
    private boolean mShowIndent;
    private boolean mShowOutline = true;
    private int mIndentWidth;
    private int mRowHeight;
    private Object mUserRef;
    private boolean mExporting;
    private boolean mAccumulateRowOpens;
    private Set<@NonNull Row<C>> mRowsToOpen;
    private int mPreservationDepth = 0;

    public void addColumn(@NonNull C column) {
        this.mColumns.add(column);
        ((Column)column).getHeaderCell().setOutlineModel(this);
    }

    public void addColumn(int index, @NonNull C column) {
        this.mColumns.add(index, column);
        ((Column)column).getHeaderCell().setOutlineModel(this);
    }

    public void addColumns(@NonNull List<@NonNull C> columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public void addListener(@NonNull IOutlineModelListener<C> listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void addNonHierarchicalRowsFast(@NonNull Collection<? extends @NonNull Row<C>> rows) {
        this.mTopLevelRows = null;
        for (Row<C> row : rows) {
            row.setOwner(this);
        }
        this.preserveSelection();
        this.mRowIndexes = null;
        this.mRows.addAll(rows);
        this.mRowSet.addAll(rows);
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowAdditions(rows.toArray(new Row[rows.size()]));
        this.clearSort();
    }

    public void addRow(int index, @NonNull Row<C> row) {
        this.addRow(index, row, false);
    }

    public void addRow(int index, @NonNull Row<C> row, boolean includeChildren) {
        ArrayList<@NonNull Row<C>> list = new ArrayList<Row<C>>();
        this.mTopLevelRows = null;
        if (includeChildren) {
            this.collectRowsAndSetOwner(list, row, false);
        } else {
            list.add(row);
            row.setOwner(this);
        }
        this.preserveSelection();
        this.mRowIndexes = null;
        this.mRows.addAll(index, list);
        this.mRowSet.addAll(list);
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowAdditions(list.toArray(new Row[list.size()]));
        this.clearSort();
    }

    public void addRow(@NonNull Row<C> row) {
        this.addRow(row, false);
    }

    public void addRow(@NonNull Row<C> row, boolean includeChildren) {
        this.addRow(this.getRowCount(), row, includeChildren);
    }

    public boolean canSelectAll() {
        return this.mSelection.canSelectAll();
    }

    public void clearSort() {
        if (this.clearSortWithoutNotify()) {
            this.notifyOfSortCleared();
        }
    }

    public boolean clearSortWithoutNotify() {
        int count = this.getColumnCount();
        boolean notify = false;
        int i = 0;
        while (i < count) {
            @NonNull C column = this.getColumnAtIndex(i);
            if (((Column)column).getSortSequence() != -1) {
                ((Column)column).setSortCriteria(-1, ((Column)column).isSortAscending());
                notify = true;
            }
            ++i;
        }
        return notify;
    }

    public @NonNull List<@NonNull Row<C>> collectRowsAndSetOwner(@NonNull List<@NonNull Row<C>> list, @NonNull Row<C> row, boolean childrenOnly) {
        if (!childrenOnly) {
            list.add(row);
            row.setOwner(this);
        }
        if (row.isOpen() && row.hasChildren()) {
            for (Row row2 : (List)NullChecking.neverNull(row.getChildren())) {
                this.collectRowsAndSetOwner(list, row2, false);
            }
        }
        return list;
    }

    public void deselect() {
        this.mSelection.deselect();
    }

    public void deselect(int rowIndex) {
        this.mSelection.deselect(rowIndex);
    }

    public void deselect(int from, int to) {
        this.mSelection.deselect(from, to);
    }

    public void deselect(@NonNull List<@NonNull Row<C>> rows) {
        TIntHashSet set = new TIntHashSet();
        for (Row<C> row : rows) {
            set.add(this.getIndexOfRow(row));
        }
        this.mSelection.deselect(set.toArray());
    }

    public void deselect(@NonNull Row<C> row) {
        this.mSelection.deselect(this.getIndexOfRow(row));
    }

    public void dispose() {
        this.mListeners.clear();
        this.removeAllColumns();
        this.removeAllRows();
        this.mSavedAnchorRow = null;
        this.mSavedSelection = null;
        this.mUserRef = null;
    }

    public @NonNull C getColumnAtIndex(int index) {
        return (C)((Column)this.mColumns.get(index));
    }

    public int getColumnCount() {
        return this.mColumns.size();
    }

    public @NonNull List<@NonNull C> getColumns() {
        return this.mColumns;
    }

    public @Nullable C getColumnWithID(int id) {
        int count = this.getColumnCount();
        int i = 0;
        while (i < count) {
            C column = this.getColumnAtIndex(i);
            if (((Column)column).getID() == id) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public @Nullable Row<C> getFirstSelectedRow() {
        int index = this.getFirstSelectedRowIndex();
        return index == -1 ? null : this.getRowAtIndex(index);
    }

    public int getFirstSelectedRowIndex() {
        return this.mSelection.firstSelectedIndex();
    }

    public @NonNull Collection<@NonNull C> getHiddenColumns() {
        @NonNull ArrayList<@NonNull Column> list = new ArrayList<Column>();
        for (Column column : this.mColumns) {
            if (column.isVisible()) continue;
            list.add(column);
        }
        return list;
    }

    public int getIndentWidth() {
        return this.mIndentWidth;
    }

    public int getIndentWidth(@NonNull Row<C> row, @NonNull C column) {
        if (this.mShowIndent && ((Column)column).isPrimary()) {
            return this.getIndentWidth() * ((this.showOutline() ? 1 : 0) + row.getDepth());
        }
        return 0;
    }

    public int getIndexOfColumn(@NonNull C column) {
        return this.mColumns.indexOf(column);
    }

    public int getIndexOfRow(@NonNull Row<C> row) {
        if (this.mRowIndexes == null) {
            this.mRowIndexes = new TObjectIntHashMap();
            int count = this.getRowCount();
            int i = 0;
            while (i < count) {
                this.mRowIndexes.put(this.mRows.get(i), i);
                ++i;
            }
        }
        int index = this.mRowIndexes.containsKey(row) ? this.mRowIndexes.get(row) : -1;
        return index;
    }

    public @Nullable Row<C> getLastSelectedRow() {
        int index = this.getLastSelectedRowIndex();
        return index == -1 ? null : this.getRowAtIndex(index);
    }

    public int getLastSelectedRowIndex() {
        return this.mSelection.lastSelectedIndex();
    }

    public int getRecursiveRowCount() {
        List<Row<C>> list = this.getTopLevelRows();
        int count = list.size();
        for (Row<C> row : list) {
            count += row.getRecursiveChildCount();
        }
        return count;
    }

    public @NonNull Row<C> getRowAtIndex(int index) {
        return this.mRows.get(index);
    }

    public int getRowCount() {
        return this.mRows.size();
    }

    public int getRowHeight() {
        return this.mRowHeight;
    }

    public @NonNull List<@NonNull Row<C>> getRows() {
        return this.mRows;
    }

    @Override
    public Object getSelectableObjectAtIndex(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return null;
        }
        return this.getRowAtIndex(index);
    }

    public @NonNull StdSelection getSelection() {
        return this.mSelection;
    }

    public @NonNull List<@NonNull Row<C>> getSelectionAsList() {
        return this.getSelectionAsList(false);
    }

    public @NonNull List<@NonNull Row<C>> getSelectionAsList(boolean minimal) {
        ArrayList<@NonNull Row<C>> list = new ArrayList<Row<C>>(this.mSelection.getCount());
        int index = this.mSelection.firstSelectedIndex();
        while (index != -1) {
            Row<C> row = this.getRowAtIndex(index);
            boolean add = true;
            if (minimal) {
                Row<C> parent = row.getParent();
                while (parent != null) {
                    if (this.mSelection.isSelected(this.getIndexOfRow(parent))) {
                        add = false;
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            if (add) {
                list.add(row);
            }
            index = this.mSelection.nextSelectedIndex(index + 1);
        }
        return list;
    }

    public int getSelectionCount() {
        return this.mSelection.getCount();
    }

    public @NonNull List<@NonNull Row<C>> getTopLevelRows() {
        if (this.mTopLevelRows == null) {
            this.mTopLevelRows = new ArrayList<Row<C>>();
            for (Row<C> row : this.mRows) {
                if (row.getParent() != null) continue;
                this.mTopLevelRows.add(row);
            }
        }
        return new ArrayList<Row<C>>(this.mTopLevelRows);
    }

    public Object getUserRef() {
        return this.mUserRef;
    }

    public int getVisibleColumnCount() {
        int count = 0;
        for (Column column : this.mColumns) {
            if (!column.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasSelection() {
        return !this.mSelection.isEmpty();
    }

    public boolean isExporting() {
        return this.mExporting;
    }

    public boolean isExtendedRowSelected(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return false;
        }
        return this.isExtendedRowSelected(this.getRowAtIndex(index));
    }

    public boolean isExtendedRowSelected(@NonNull Row<C> row) {
        @Nullable Row<C> currentRow = row;
        while (currentRow != null) {
            if (this.isRowSelected(currentRow)) {
                return true;
            }
            currentRow = currentRow.getParent();
        }
        return false;
    }

    public boolean isRowSelected(int index) {
        return this.mSelection.isSelected(index);
    }

    public boolean isRowSelected(@NonNull Row<C> row) {
        return this.mSelection.isSelected(this.getIndexOfRow(row));
    }

    public void removeAllColumns() {
        this.mColumns.clear();
    }

    public void removeAllRows() {
        @NonNull Row @NonNull [] rows = this.mRows.toArray(new Row[0]);
        this.mTopLevelRows = null;
        this.mSelection.deselect();
        this.mSelection.setSize(0);
        this.notifyOfRowsWillBeRemoved(rows);
        this.mRowIndexes = null;
        this.mRows.clear();
        this.mRowSet.clear();
        Row[] rowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Row element = rowArray[n2];
            element.setOwner(null);
            ++n2;
        }
        this.notifyOfRowsWereRemoved(rows);
    }

    public void removeColumn(@NonNull C column) {
        this.mColumns.remove(column);
    }

    public void removeListener(@NonNull IOutlineModelListener<C> listener) {
        this.mListeners.remove(listener);
    }

    public void removeRow(int index) {
        this.removeRows(new int[]{index});
    }

    public void removeRow(@NonNull Row<C> row) {
        this.removeRows(Arrays.asList(row));
    }

    public void removeRows(int[] indexes) {
        TIntHashSet set = new TIntHashSet();
        int max = this.getRowCount();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index > -1 && index < max) {
                this.collectRowIndexes(set, index);
            }
            ++n2;
        }
        this.removeRowsInternal(set.toArray());
    }

    public void removeRows(@NonNull Collection<? extends @NonNull Row<C>> rows) {
        TIntHashSet set = new TIntHashSet();
        for (Row<C> row : rows) {
            int index;
            int n = index = this.mRowIndexes != null ? this.getIndexOfRow(row) : this.mRows.indexOf(row);
            if (index <= -1) continue;
            this.collectRowIndexes(set, index);
        }
        this.removeRowsInternal(set.toArray());
    }

    public void removeSelection() {
        int[] indexes = this.mSelection.getSelectedIndexes();
        this.mSelection.deselect();
        this.removeRows(indexes);
    }

    public void rowOpenStateChanged(Row<C> row, boolean open) {
        if (row.hasChildren() && this.mRowSet.contains(row)) {
            if (open) {
                if (this.mAccumulateRowOpens) {
                    Row<C> parent = row.getParent();
                    while (parent != null) {
                        if (this.mRowsToOpen.contains(parent)) {
                            return;
                        }
                        parent = parent.getParent();
                    }
                    this.mRowsToOpen.add(row);
                } else {
                    this.addChildren(row);
                }
            } else {
                this.removeRows((Collection)NullChecking.neverNull(row.getChildren()));
            }
        }
    }

    public void select() {
        this.mSelection.select();
    }

    public void select(@NonNull Collection<? extends @NonNull Row<C>> rows, boolean add) {
        TIntHashSet set = new TIntHashSet();
        for (Row<C> row : rows) {
            set.add(this.getIndexOfRow(row));
        }
        this.mSelection.select(set.toArray(), add);
    }

    public void select(int rowIndex, boolean add) {
        this.mSelection.select(rowIndex, add);
    }

    public void select(int from, int to, boolean add) {
        this.mSelection.select(from, to, add);
    }

    public void select(int[] rowIndexes, boolean add) {
        this.mSelection.select(rowIndexes, add);
    }

    public void select(@NonNull Row<C> row, boolean add) {
        this.mSelection.select(this.getIndexOfRow(row), add);
    }

    @Override
    public void selectionAboutToChange() {
        if (this.mNotifyOfSelections) {
            IOutlineModelListener<C>[] listeners;
            IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
                element.selectionWillChange(this);
                ++n2;
            }
        }
    }

    @Override
    public void selectionDidChange() {
        if (this.mNotifyOfSelections) {
            IOutlineModelListener<C>[] listeners;
            IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
                element.selectionDidChange(this);
                ++n2;
            }
        }
    }

    public void setAccumulateRowOpens(boolean accumulate) {
        if (this.mAccumulateRowOpens != accumulate) {
            this.mAccumulateRowOpens = accumulate;
            if (accumulate) {
                this.mRowsToOpen = new HashSet<Row<C>>();
            } else {
                if (this.mRowsToOpen != null) {
                    for (Row<C> row : this.mRowsToOpen) {
                        this.rowOpenStateChanged(row, true);
                    }
                }
                this.mRowsToOpen = null;
            }
        }
    }

    public void setExporting(boolean exporting) {
        this.mExporting = exporting;
    }

    public void setIndentWidth(int width) {
        this.mIndentWidth = width;
    }

    public void setRowHeight(int height) {
        this.mRowHeight = height;
    }

    public void setShowIndent(boolean show) {
        this.mShowIndent = show;
    }

    public void setShowOutline(boolean show) {
        this.mShowOutline = show;
    }

    public void setUserRef(Object userRef) {
        this.mUserRef = userRef;
    }

    public boolean showIndent() {
        return this.mShowIndent;
    }

    public boolean showOutline() {
        return this.mShowOutline;
    }

    public void sort() {
        this.sort(false);
    }

    public void sort(boolean restoring) {
        this.mTopLevelRows = null;
        this.preserveSelection();
        this.mRowIndexes = null;
        RowSorter.sort(this.mColumns, this.mRows, true);
        this.restoreSelection();
        this.notifyOfSort(restoring);
    }

    protected void removeRowsInternal(int[] indexes) {
        @NonNull Row @NonNull [] rows = new Row[indexes.length];
        this.mTopLevelRows = null;
        Arrays.sort(indexes);
        int i = 0;
        while (i < indexes.length) {
            rows[i] = this.getRowAtIndex(indexes[i]);
            ++i;
        }
        this.preserveSelection();
        this.notifyOfRowsWillBeRemoved(rows);
        this.mRowIndexes = null;
        i = indexes.length - 1;
        while (i >= 0) {
            this.mRowSet.remove(this.mRows.remove(indexes[i]));
            rows[i].setOwner(null);
            --i;
        }
        this.mSelection.setSize(this.getRowCount());
        this.restoreSelection();
        this.notifyOfRowsWereRemoved(rows);
    }

    private void addChildren(@NonNull Row<C> row) {
        @NonNull List<@NonNull Row<C>> list = this.collectRowsAndSetOwner(new ArrayList<Row<C>>(), row, true);
        this.preserveSelection();
        this.mRows.addAll(this.mRows.indexOf(row) + 1, list);
        this.mRowSet.addAll(list);
        this.mSelection.setSize(this.getRowCount());
        this.mRowIndexes = null;
        this.restoreSelection();
        this.notifyOfRowAdditions(list.toArray(new Row[0]));
    }

    private int collectRowIndexes(TIntHashSet set, int index) {
        @NonNull Row<C> row = this.getRowAtIndex(index);
        int max = this.getRowCount();
        set.add(index++);
        while (index < max) {
            Row<C> next = this.getRowAtIndex(index);
            if (!next.isDescendentOf(row)) break;
            set.add(index++);
        }
        return index;
    }

    private @NonNull IOutlineModelListener<C> @NonNull [] getCurrentListeners() {
        return this.mListeners.toArray(new IOutlineModelListener[0]);
    }

    private void notifyOfRowAdditions(@NonNull Row<C> @NonNull [] rows) {
        IOutlineModelListener<C>[] listeners;
        IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
            element.rowsAdded(this, rows);
            ++n2;
        }
    }

    private void notifyOfRowsWereRemoved(@NonNull Row<C> @NonNull [] rows) {
        IOutlineModelListener<C>[] listeners;
        IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
            element.rowsWereRemoved(this, rows);
            ++n2;
        }
    }

    private void notifyOfRowsWillBeRemoved(@NonNull Row<C> @NonNull [] rows) {
        IOutlineModelListener<C>[] listeners;
        IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
            element.rowsWillBeRemoved(this, rows);
            ++n2;
        }
    }

    private void notifyOfSort(boolean restoring) {
        IOutlineModelListener<C>[] listeners;
        IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
            element.sorted(this, restoring);
            ++n2;
        }
    }

    void notifyOfSortCleared() {
        IOutlineModelListener<C>[] listeners;
        IOutlineModelListener<C>[] iOutlineModelListenerArray = listeners = this.getCurrentListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineModelListener<C> element = iOutlineModelListenerArray[n2];
            element.sortCleared(this);
            ++n2;
        }
    }

    void preserveSelection() {
        if (this.mPreservationDepth++ == 0) {
            int anchor = this.mSelection.getAnchor();
            this.mSavedAnchorRow = anchor != -1 ? this.getRowAtIndex(anchor) : null;
            this.mSavedSelection = this.getSelectionAsList();
            this.mNotifyOfSelections = false;
            this.deselect();
        }
    }

    void restoreSelection() {
        if (--this.mPreservationDepth == 0) {
            this.select((Collection)NullChecking.neverNull(this.mSavedSelection), false);
            if (this.mSavedAnchorRow != null) {
                this.mSelection.setAnchor(this.getIndexOfRow(this.mSavedAnchorRow));
            }
            this.mSavedAnchorRow = null;
            this.mSavedSelection = null;
            this.mNotifyOfSelections = true;
        }
    }
}

