/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public abstract class CellEditor<C extends Column<C>> {
    private @NonNull Outline<C> mOutline;
    private @NonNull Row<C> mRow;
    private @NonNull C mColumn;
    private @Nullable Control mControl;

    public CellEditor(@NonNull Outline<C> outline, @NonNull Row<C> row, @NonNull C column) {
        this.mOutline = outline;
        this.mRow = row;
        this.mColumn = column;
    }

    public void adjustToOutline() {
        Rectangle bounds = this.getVirtualBounds();
        Point where = this.mOutline.fromVirtual(new Point(bounds.x, bounds.y));
        this.getControl().setBounds(where.x, where.y, bounds.width, bounds.height);
    }

    public abstract void commit(boolean var1);

    public abstract @NonNull Control createControl();

    public void dispose() {
        if (this.mControl != null) {
            this.mControl.dispose();
        }
    }

    public @NonNull C getColumn() {
        return this.mColumn;
    }

    public final @NonNull Control getControl() {
        Control mControl = this.mControl;
        if (mControl == null) {
            this.mControl = mControl = this.createControl();
        }
        return mControl;
    }

    public @NonNull Outline<C> getOutline() {
        return this.mOutline;
    }

    public @NonNull Row<C> getRow() {
        return this.mRow;
    }

    public @NonNull Rectangle getVirtualBounds() {
        return this.mOutline.getCellBounds(this.mRow, this.mColumn);
    }
}

