/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public abstract class BlockRow {
    private BlockOutlineModel mOwner;
    private boolean mOpen;
    private BlockRow mParent;
    private ArrayList<BlockRow> mChildren;

    public boolean addChild(BlockRow row) {
        if (this.canHaveChildren()) {
            row.removeFromParent();
            this.getChildList().add(row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public boolean canHaveChildren() {
        return this.mChildren != null;
    }

    public void disclose() {
        BlockRow parent = this.getParent();
        while (parent != null) {
            parent.setOpen(true);
            parent = parent.getParent();
        }
    }

    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return null;
    }

    public BlockRow getChild(int index) {
        return index >= 0 && index < this.getChildCount() ? this.getChildList().get(index) : null;
    }

    public int getChildCount() {
        return this.canHaveChildren() ? this.getChildList().size() : 0;
    }

    public List<BlockRow> getChildren() {
        return this.canHaveChildren() ? Collections.unmodifiableList(this.getChildList()) : null;
    }

    public abstract double getDataAsDouble(BlockColumn var1);

    public abstract long getDataAsLong(BlockColumn var1);

    public abstract String getDataAsText(BlockColumn var1);

    public int getDepth() {
        BlockRow parent = this.mParent;
        int depth = 0;
        while (parent != null) {
            ++depth;
            parent = parent.mParent;
        }
        return depth;
    }

    public Image getImage(BlockColumn column) {
        return null;
    }

    public int getIndexOfChild(BlockRow row) {
        if (this.canHaveChildren()) {
            return this.getChildList().indexOf(row);
        }
        return -1;
    }

    public BlockOutlineModel getOwner() {
        if (this.mOwner == null && this.mParent != null) {
            return this.mParent.getOwner();
        }
        return this.mOwner;
    }

    public BlockRow getParent() {
        return this.mParent;
    }

    public BlockRow[] getPath() {
        ArrayList<BlockRow> list = new ArrayList<BlockRow>();
        BlockRow parent = this.mParent;
        list.add(this);
        while (parent != null) {
            list.add(0, parent);
            parent = parent.mParent;
        }
        return list.toArray(new BlockRow[0]);
    }

    public int getPreferredHeight(BlockOutline outline, List<BlockColumn> columns) {
        int preferredHeight = 0;
        GC gc = outline.createTemporaryGC();
        for (BlockColumn column : columns) {
            int height = column.getRowCell((BlockRow)this).getPreferredSize((GC)gc, (BlockRow)this, (BlockColumn)column).y;
            if (height <= preferredHeight) continue;
            preferredHeight = height;
        }
        gc.dispose();
        return preferredHeight;
    }

    public int getRecursiveChildCount() {
        int count = 0;
        if (this.canHaveChildren()) {
            ArrayList<BlockRow> list = this.getChildList();
            count += list.size();
            for (BlockRow row : list) {
                count += row.getRecursiveChildCount();
            }
        }
        return count;
    }

    public String getToolTipText(BlockColumn column) {
        return column.getToolTipText();
    }

    public String getToolTipTextWhenTruncated(BlockColumn column) {
        String content = this.getDataAsText(column);
        Object tooltip = this.getToolTipText(column);
        if (content == null) {
            return tooltip;
        }
        if (tooltip != null) {
            if (((String)tooltip).length() > 0) {
                tooltip = (String)tooltip + "\n\n";
            }
            tooltip = (String)tooltip + content;
        } else {
            tooltip = content;
        }
        return tooltip;
    }

    public BlockRow getTopParentOrSelf() {
        BlockRow row = this;
        while (row.getParent() != null) {
            row = row.getParent();
        }
        return row;
    }

    public boolean hasChildren() {
        return this.canHaveChildren() && !this.getChildList().isEmpty();
    }

    public boolean insertChild(int index, BlockRow row) {
        if (this.canHaveChildren()) {
            int max;
            row.removeFromParent();
            if (index < 0) {
                index = 0;
            }
            if (index > (max = this.getChildList().size())) {
                index = max;
            }
            this.getChildList().add(index, row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public boolean isChildOf(BlockRow parent) {
        return this.mParent == parent;
    }

    public boolean isDescendentOf(BlockRow row) {
        BlockRow parent = this.mParent;
        while (parent != null) {
            if (parent == row) {
                return true;
            }
            parent = parent.mParent;
        }
        return false;
    }

    public boolean isOpen() {
        return this.mOpen;
    }

    public void removeAllChildren() {
        ArrayList<BlockRow> children = this.getChildList();
        if (children != null) {
            for (BlockRow child : children) {
                child.mParent = null;
            }
            children.clear();
        }
    }

    public boolean removeChild(BlockRow row) {
        if (row.isChildOf(this)) {
            this.getChildList().remove(row);
            row.mParent = null;
            return true;
        }
        return false;
    }

    public void removeFromParent() {
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
    }

    public void setCanHaveChildren(boolean canHaveChildren) {
        if (canHaveChildren != this.canHaveChildren()) {
            if (canHaveChildren) {
                this.mChildren = new ArrayList();
            } else {
                this.setOpen(false);
                this.mChildren = null;
            }
        }
    }

    public abstract void setData(BlockColumn var1, Object var2);

    public void setOpen(boolean open) {
        if (this.mOpen != open && (!open || open && this.canHaveChildren())) {
            this.mOpen = open;
            if (this.mOwner != null) {
                this.mOwner.rowOpenStateChanged(this, this.mOpen);
            }
        }
    }

    protected ArrayList<BlockRow> getChildList() {
        return this.mChildren;
    }

    void setOwner(BlockOutlineModel owner) {
        this.mOwner = owner;
    }
}

