/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockColumnResizeTracker;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineMessages;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class BlockHeader
extends Block
implements Block.IBlockMoveListener,
Block.IBlockResizeListener {
    private BlockOutline mOutline;
    private DragTracker mTracker;

    public BlockHeader() {
        this.setBackgroundColor(Colors.getWidgetBackground());
    }

    @Override
    public final void blockMoved(Block block) {
        this.repaint();
    }

    @Override
    public final void blockResized(Block block) {
        this.repaint();
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        Point size = super.getPreferredSize(widthHint, heightHint);
        size.x = 32;
        return size;
    }

    public final BlockOutline getOutline() {
        return this.mOutline;
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        if (this.mOutline != null) {
            height = 0;
            for (BlockColumn col : this.mOutline.getModel().getColumns()) {
                int colHeight;
                if (!col.isVisible()) continue;
                int colWidth = col.getWidth();
                if (colWidth == -1) {
                    colWidth = col.getPreferredWidth(this.mOutline);
                    col.setWidth(this.mOutline, colWidth);
                }
                if ((colHeight = col.getPreferredHeaderSize((BlockOutline)this.mOutline).y) <= height) continue;
                height = colHeight;
            }
            height += 2;
            width = this.mOutline.getViewPortBounds().width;
        }
        return new Point(width, height);
    }

    public final void setOutline(BlockOutline outline) {
        if (this.mOutline != outline) {
            if (this.mOutline != null) {
                this.mOutline.removeResizeListener(this);
                this.mOutline.removeMoveListener(this);
            }
            this.mOutline = outline;
            if (outline != null) {
                outline.addResizeListener(this);
                outline.addMoveListener(this);
            }
        }
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (this.mOutline != null) {
            if (button == 1) {
                int x = where.x + this.mOutline.getViewPortBounds().x;
                int columnDivider = this.mOutline.overColumnDivider(x);
                if (columnDivider != -1 && this.mOutline.isColumnResizeAllowed()) {
                    this.mTracker = new BlockColumnResizeTracker(this, x, columnDivider, count);
                } else {
                    BlockColumn column = this.mOutline.overColumn(x);
                    if (column != null && column.getHeaderCell().isSortAllowed()) {
                        this.mTracker = new SortTracker(column);
                    }
                }
            } else if (button == 3) {
                this.showContextMenu(where);
            }
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected final void mouseEnter(Point where, int stateMask) {
        this.adjustCursorAndTooltip(where);
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.adjustCursorAndTooltip(where);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        Color dividerColor = Colors.getDivider();
        Rectangle bounds = this.getLocalBounds();
        int bottom = bounds.y + bounds.height - 1;
        int origWidth = bounds.width;
        if (this.mOutline != null) {
            int left = bounds.x;
            int right = left + bounds.width;
            Rectangle outlineViewPort = this.mOutline.getViewPortBounds();
            bounds.x = -outlineViewPort.x;
            --bounds.height;
            for (BlockColumn col : this.mOutline.getModel().getColumns()) {
                if (!col.isVisible()) continue;
                bounds.width = this.mOutline.getColumnWidth(col);
                if (bounds.x <= right && bounds.x + bounds.width >= left) {
                    ++bounds.y;
                    col.drawHeaderCell(gc, bounds);
                    --bounds.y;
                }
                bounds.x += bounds.width;
                gc.setForeground(dividerColor);
                gc.drawLine(bounds.x, bounds.y, bounds.x, bottom);
                ++bounds.x;
            }
        }
        gc.setForeground(dividerColor);
        gc.drawLine(0, bottom, origWidth, bottom);
    }

    private void adjustCursorAndTooltip(Point where) {
        BlockColumn column;
        String tip = null;
        int cursor = 0;
        int x = where.x + this.mOutline.getViewPortBounds().x;
        int columnDivider = this.mOutline.overColumnDivider(x);
        if (columnDivider != -1 && this.mOutline.isColumnResizeAllowed()) {
            cursor = 9;
        }
        if ((column = this.mOutline.overColumn(x)) != null) {
            tip = column.getHeaderCell().getToolTipText(this.mOutline, null, column);
        }
        this.setCursor(this.getDisplay().getSystemCursor(cursor));
        this.setToolTip(tip);
    }

    private void showContextMenu(Point where) {
        Menu menu = new Menu((Control)this.getOwner());
        BlockOutlineModel model = this.mOutline.getModel();
        int columnCount = model.getVisibleColumnCount();
        for (BlockColumn column : model.getColumns()) {
            boolean visible = column.isVisible();
            MenuItem item = new MenuItem(menu, 32);
            item.setText(column.getSanitizedName());
            item.setData((Object)column.getID());
            item.setSelection(visible);
            item.setEnabled(!column.isPrimary() && (!visible || columnCount != 1));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    BlockOutline outline = BlockHeader.this.getOutline();
                    BlockColumn col = outline.getModel().getColumnWithID((Integer)event.widget.getData());
                    if (col != null) {
                        col.setVisible(!col.isVisible());
                        outline.lazyAdjust();
                    }
                }
            });
        }
        ContextMenu.createSeparator(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(BlockOutlineMessages.SHOW_ALL_COLUMNS);
        item.setEnabled(columnCount != model.getColumnCount());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BlockOutline outline = BlockHeader.this.getOutline();
                for (BlockColumn column : outline.getModel().getColumns()) {
                    column.setVisible(true);
                }
                outline.lazyAdjust();
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(BlockOutlineMessages.RESET_COLUMNS);
        item.setEnabled(!this.mOutline.getConfig().equals(this.mOutline.getDefaultConfig()));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BlockOutline outline = BlockHeader.this.getOutline();
                outline.applyConfig(outline.getDefaultConfig(), false, true);
                outline.lazyAdjust();
            }
        });
        this.showContextMenu(menu, where);
    }

    private class SortTracker
    extends DragTracker {
        private BlockColumn mSortColumn;

        SortTracker(BlockColumn column) {
            super(BlockHeader.this);
            this.mSortColumn = column;
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            BlockOutline outline = BlockHeader.this.getOutline();
            int x = where.x + outline.getViewPortBounds().x;
            if (this.mSortColumn == outline.overColumn(x)) {
                boolean sortAscending = this.mSortColumn.isSortAscending();
                if (this.mSortColumn.getSortSequence() != -1) {
                    sortAscending = !sortAscending;
                }
                outline.setSort(this.mSortColumn, sortAscending, (stateMask & 0x20000) != 0);
            }
        }
    }
}

