/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockHeader;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import org.eclipse.swt.graphics.Point;

public class BlockColumnResizeTracker
extends DragTracker {
    private int mStartX;
    private int mStartScroll;
    private int mBaseWidth;
    private BlockColumn mColumn;

    BlockColumnResizeTracker(Block block, int x, int column, int count) {
        super(block);
        BlockOutline outline = this.getOutline();
        this.mStartX = x;
        this.mStartScroll = outline.getX();
        this.mColumn = outline.getModel().getColumns().get(column);
        this.mBaseWidth = outline.getColumnWidth(this.mColumn);
        if (count == 2) {
            int maxWidth = this.mColumn.getMaxWidth();
            this.mColumn.setNoMaxWidth();
            this.mColumn.setPreferredWidth(this.mColumn.getDefaultPreferredWidth());
            this.mColumn.setWidth(outline, this.mColumn.getPreferredWidth(outline));
            this.mColumn.setMaxWidth(maxWidth);
            outline.pack();
            outline.redrawAll();
            this.mColumn = null;
        }
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        if (this.mColumn != null) {
            BlockOutline outline = this.getOutline();
            int scroll = outline.getX();
            int x = where.x;
            if (this.getBlock() instanceof BlockHeader) {
                x += outline.getViewPortBounds().x;
            }
            int size = Math.max(this.mBaseWidth + x - (this.mStartScroll - scroll) - this.mStartX, this.mColumn.getPreferredHeaderSize((BlockOutline)outline).x);
            this.mColumn.setPreferredWidth(size);
            this.mColumn.setWidth(outline, size);
            outline.pack();
            outline.redrawAll();
        }
    }

    private BlockOutline getOutline() {
        Block block = this.getBlock();
        if (block instanceof BlockOutline) {
            return (BlockOutline)block;
        }
        return ((BlockHeader)block).getOutline();
    }
}

