/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;

public final class PrecisionLayout
implements IBlockLayout {
    private int mRowCount;
    private int mColumns = 1;
    private int mMarginTop;
    private int mMarginLeft;
    private int mMarginBottom;
    private int mMarginRight;
    private int mHSpacing;
    private int mVSpacing;
    private int mHAlign = 16384;
    private int mVAlign = 16384;
    private boolean mEqualColumns;

    private static final Block[] getChildren(Block target, boolean useMinimumSize) {
        ArrayList<Block> children = new ArrayList<Block>();
        Block[] blockArray = target.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block child = blockArray[n2];
            PrecisionLayoutData data = PrecisionLayout.getLayoutData(child);
            data.clearCache();
            if (!data.shouldExclude()) {
                children.add(child);
                data.computeSize(child, -1, -1, useMinimumSize);
            }
            ++n2;
        }
        return children.toArray(new Block[children.size()]);
    }

    private static final PrecisionLayoutData getLayoutData(Block block) {
        Object layoutData = block.getLayoutData();
        if (layoutData instanceof PrecisionLayoutData) {
            return (PrecisionLayoutData)layoutData;
        }
        PrecisionLayoutData data = new PrecisionLayoutData();
        block.setLayoutData(data);
        return data;
    }

    public final int getBottomMargin() {
        return this.mMarginBottom;
    }

    public final int getColumns() {
        return this.mColumns;
    }

    public final int getHorizontalAlignment() {
        return this.mHAlign;
    }

    public final int getHorizontalSpacing() {
        return this.mHSpacing;
    }

    public final int getLeftMargin() {
        return this.mMarginLeft;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return this.layout(target, false, widthHint, heightHint, true);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        return this.layout(target, false, widthHint, heightHint, false);
    }

    public final int getRightMargin() {
        return this.mMarginRight;
    }

    public final int getTopMargin() {
        return this.mMarginTop;
    }

    public final int getVerticalAlignment() {
        return this.mVAlign;
    }

    public final int getVerticalSpacing() {
        return this.mHSpacing;
    }

    public final boolean isEqualColumns() {
        return this.mEqualColumns;
    }

    @Override
    public final void layout(Block target) {
        this.layout(target, true, target.getWidth(), target.getHeight(), false);
    }

    public final PrecisionLayout setAlignment(int horizontal, int vertical) {
        this.mHAlign = horizontal;
        this.mVAlign = vertical;
        return this;
    }

    public final PrecisionLayout setBottomMargin(int bottom) {
        this.mMarginBottom = bottom;
        return this;
    }

    public final PrecisionLayout setColumns(int columns) {
        this.mColumns = columns;
        return this;
    }

    public final PrecisionLayout setEqualColumns(boolean equal) {
        this.mEqualColumns = equal;
        return this;
    }

    public final PrecisionLayout setHorizontalAlignment(int alignment) {
        this.mHAlign = alignment;
        return this;
    }

    public final PrecisionLayout setHorizontalSpacing(int spacing) {
        this.mHSpacing = spacing;
        return this;
    }

    public final PrecisionLayout setLeftMargin(int left) {
        this.mMarginLeft = left;
        return this;
    }

    public final PrecisionLayout setMargins(int margins) {
        this.mMarginTop = margins;
        this.mMarginLeft = margins;
        this.mMarginBottom = margins;
        this.mMarginRight = margins;
        return this;
    }

    public final PrecisionLayout setMargins(int top, int left, int bottom, int right) {
        this.mMarginTop = top;
        this.mMarginLeft = left;
        this.mMarginBottom = bottom;
        this.mMarginRight = right;
        return this;
    }

    public final PrecisionLayout setRightMargin(int right) {
        this.mMarginRight = right;
        return this;
    }

    public final PrecisionLayout setSpacing(int horizontal, int vertical) {
        this.mHSpacing = horizontal;
        this.mVSpacing = vertical;
        return this;
    }

    public final PrecisionLayout setTopMargin(int top) {
        this.mMarginTop = top;
        return this;
    }

    public final PrecisionLayout setVerticalAlignment(int alignment) {
        this.mVAlign = alignment;
        return this;
    }

    public final PrecisionLayout setVerticalSpacing(int spacing) {
        this.mVSpacing = spacing;
        return this;
    }

    private final int[] adjustColumnWidths(int width, Block[][] grid) {
        int[] widths;
        block52: {
            int k;
            int i;
            boolean[] expandColumn;
            int[] minWidths;
            int expandCount;
            int availableWidth;
            block53: {
                availableWidth = width - this.mHSpacing * (this.mColumns - 1) - (this.mMarginLeft + this.mMarginRight);
                expandCount = 0;
                widths = new int[this.mColumns];
                minWidths = new int[this.mColumns];
                expandColumn = new boolean[this.mColumns];
                int j = 0;
                while (j < this.mColumns) {
                    int hSpan;
                    PrecisionLayoutData data;
                    i = 0;
                    while (i < this.mRowCount) {
                        data = this.getData(grid, i, j, this.mRowCount, true);
                        if (data != null && (hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns))) == 1) {
                            int w = data.getCachedWidth() + data.getLeftMargin() + data.getRightMargin();
                            if (widths[j] < w) {
                                widths[j] = w;
                            }
                            if (data.shouldGrabHorizontalSpace()) {
                                if (!expandColumn[j]) {
                                    ++expandCount;
                                }
                                expandColumn[j] = true;
                            }
                            int minimumWidth = data.getCachedMinimumWidth();
                            if (!data.shouldGrabHorizontalSpace() || minimumWidth != 0) {
                                w = !data.shouldGrabHorizontalSpace() || minimumWidth == -1 ? data.getCachedWidth() : minimumWidth;
                                minWidths[j] = Math.max(minWidths[j], w += data.getLeftMargin() + data.getRightMargin());
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.mRowCount) {
                        data = this.getData(grid, i, j, this.mRowCount, false);
                        if (data != null && (hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns))) > 1) {
                            int w;
                            int spanWidth = 0;
                            int spanMinWidth = 0;
                            int spanExpandCount = 0;
                            int k2 = 0;
                            while (k2 < hSpan) {
                                spanWidth += widths[j - k2];
                                spanMinWidth += minWidths[j - k2];
                                if (expandColumn[j - k2]) {
                                    ++spanExpandCount;
                                }
                                ++k2;
                            }
                            if (data.shouldGrabHorizontalSpace() && spanExpandCount == 0) {
                                ++expandCount;
                                expandColumn[j] = true;
                            }
                            if ((w = data.getCachedWidth() + data.getLeftMargin() + data.getRightMargin() - spanWidth - (hSpan - 1) * this.mHSpacing) > 0) {
                                if (this.mEqualColumns) {
                                    int equalWidth = (w + spanWidth) / hSpan;
                                    remainder = (w + spanWidth) % hSpan;
                                    last = -1;
                                    k = 0;
                                    while (k < hSpan) {
                                        last = j - k;
                                        widths[last] = Math.max(equalWidth, widths[last]);
                                        ++k;
                                    }
                                    if (last > -1) {
                                        int n = last;
                                        widths[n] = widths[n] + remainder;
                                    }
                                } else if (spanExpandCount == 0) {
                                    int n = j;
                                    widths[n] = widths[n] + w;
                                } else {
                                    int delta = w / spanExpandCount;
                                    remainder = w % spanExpandCount;
                                    last = -1;
                                    k = 0;
                                    while (k < hSpan) {
                                        if (expandColumn[j - k]) {
                                            int n = last = j - k;
                                            widths[n] = widths[n] + delta;
                                        }
                                        ++k;
                                    }
                                    if (last > -1) {
                                        int n = last;
                                        widths[n] = widths[n] + remainder;
                                    }
                                }
                            }
                            int minimumWidth = data.getCachedMinimumWidth();
                            if (!data.shouldGrabHorizontalSpace() || minimumWidth != 0) {
                                int n = w = !data.shouldGrabHorizontalSpace() || minimumWidth == -1 ? data.getCachedWidth() : minimumWidth;
                                if ((w += data.getLeftMargin() + data.getRightMargin() - spanMinWidth - (hSpan - 1) * this.mHSpacing) > 0) {
                                    if (spanExpandCount == 0) {
                                        int n2 = j;
                                        minWidths[n2] = minWidths[n2] + w;
                                    } else {
                                        int delta = w / spanExpandCount;
                                        int remainder = w % spanExpandCount;
                                        int last = -1;
                                        k = 0;
                                        while (k < hSpan) {
                                            if (expandColumn[j - k]) {
                                                int n3 = last = j - k;
                                                minWidths[n3] = minWidths[n3] + delta;
                                            }
                                            ++k;
                                        }
                                        if (last > -1) {
                                            int n4 = last;
                                            minWidths[n4] = minWidths[n4] + remainder;
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                if (!this.mEqualColumns) break block53;
                int minColumnWidth = 0;
                int columnWidth = 0;
                int i2 = 0;
                while (i2 < this.mColumns) {
                    minColumnWidth = Math.max(minColumnWidth, minWidths[i2]);
                    columnWidth = Math.max(columnWidth, widths[i2]);
                    ++i2;
                }
                columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / this.mColumns);
                i2 = 0;
                while (i2 < this.mColumns) {
                    expandColumn[i2] = expandCount > 0;
                    widths[i2] = columnWidth;
                    ++i2;
                }
                break block52;
            }
            if (width == -1 || expandCount <= 0) break block52;
            int totalWidth = 0;
            i = 0;
            while (i < this.mColumns) {
                totalWidth += widths[i];
                ++i;
            }
            int c = expandCount;
            int remainder = availableWidth - totalWidth;
            int delta = remainder / c;
            remainder %= c;
            int last = -1;
            while (totalWidth != availableWidth) {
                int j = 0;
                while (j < this.mColumns) {
                    if (expandColumn[j]) {
                        if (widths[j] + delta > minWidths[j]) {
                            last = j;
                            widths[last] = widths[j] + delta;
                        } else {
                            widths[j] = minWidths[j];
                            expandColumn[j] = false;
                            --c;
                        }
                    }
                    ++j;
                }
                if (last > -1) {
                    int n = last;
                    widths[n] = widths[n] + remainder;
                }
                j = 0;
                while (j < this.mColumns) {
                    int i3 = 0;
                    while (i3 < this.mRowCount) {
                        int hSpan;
                        PrecisionLayoutData data = this.getData(grid, i3, j, this.mRowCount, false);
                        if (data != null && (hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns))) > 1) {
                            int minimumWidth = data.getCachedMinimumWidth();
                            if (!data.shouldGrabHorizontalSpace() || minimumWidth != 0) {
                                int w;
                                int spanWidth = 0;
                                int spanExpandCount = 0;
                                k = 0;
                                while (k < hSpan) {
                                    spanWidth += widths[j - k];
                                    if (expandColumn[j - k]) {
                                        ++spanExpandCount;
                                    }
                                    ++k;
                                }
                                int n = w = !data.shouldGrabHorizontalSpace() || minimumWidth == -1 ? data.getCachedWidth() : minimumWidth;
                                if ((w += data.getLeftMargin() + data.getRightMargin() - spanWidth - (hSpan - 1) * this.mHSpacing) > 0) {
                                    if (spanExpandCount == 0) {
                                        int n5 = j;
                                        widths[n5] = widths[n5] + w;
                                    } else {
                                        int delta2 = w / spanExpandCount;
                                        int remainder2 = w % spanExpandCount;
                                        int last2 = -1;
                                        int k3 = 0;
                                        while (k3 < hSpan) {
                                            if (expandColumn[j - k3]) {
                                                last2 = j - k3;
                                                widths[last2] = widths[last2] + delta2;
                                            }
                                            ++k3;
                                        }
                                        if (last2 > -1) {
                                            int n6 = last2;
                                            widths[n6] = widths[n6] + remainder2;
                                        }
                                    }
                                }
                            }
                        }
                        ++i3;
                    }
                    ++j;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i4 = 0;
                    while (i4 < this.mColumns) {
                        totalWidth += widths[i4];
                        ++i4;
                    }
                    delta = (availableWidth - totalWidth) / c;
                    remainder = (availableWidth - totalWidth) % c;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        return widths;
    }

    private final int[] adjustRowHeights(int height, Block[][] grid) {
        int k;
        int availableHeight = height - this.mVSpacing * (this.mRowCount - 1) - (this.mMarginTop + this.mMarginBottom);
        int expandCount = 0;
        int[] heights = new int[this.mRowCount];
        int[] minHeights = new int[this.mRowCount];
        boolean[] expandRow = new boolean[this.mRowCount];
        int i = 0;
        while (i < this.mRowCount) {
            int vSpan;
            PrecisionLayoutData data;
            int j = 0;
            while (j < this.mColumns) {
                data = this.getData(grid, i, j, this.mRowCount, true);
                if (data != null && (vSpan = Math.max(1, Math.min(data.getVerticalSpan(), this.mRowCount))) == 1) {
                    int h = data.getCachedHeight() + data.getTopMargin() + data.getBottomMargin();
                    heights[i] = Math.max(heights[i], h);
                    if (data.shouldGrabVerticalSpace()) {
                        if (!expandRow[i]) {
                            ++expandCount;
                        }
                        expandRow[i] = true;
                    }
                    int minimumHeight = data.getMinimumHeight();
                    if (!data.shouldGrabVerticalSpace() || minimumHeight != 0) {
                        h = !data.shouldGrabVerticalSpace() || minimumHeight == -1 ? data.getCachedHeight() : minimumHeight;
                        minHeights[i] = Math.max(minHeights[i], h += data.getTopMargin() + data.getBottomMargin());
                    }
                }
                ++j;
            }
            j = 0;
            while (j < this.mColumns) {
                data = this.getData(grid, i, j, this.mRowCount, false);
                if (data != null && (vSpan = Math.max(1, Math.min(data.getVerticalSpan(), this.mRowCount))) > 1) {
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k2 = 0;
                    while (k2 < vSpan) {
                        spanHeight += heights[i - k2];
                        spanMinHeight += minHeights[i - k2];
                        if (expandRow[i - k2]) {
                            ++spanExpandCount;
                        }
                        ++k2;
                    }
                    if (data.shouldGrabVerticalSpace() && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i] = true;
                    }
                    if ((h = data.getCachedHeight() + data.getTopMargin() + data.getBottomMargin() - spanHeight - (vSpan - 1) * this.mVSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i;
                            heights[n] = heights[n] + h;
                        } else {
                            int delta = h / spanExpandCount;
                            int remainder = h % spanExpandCount;
                            int last = -1;
                            int k3 = 0;
                            while (k3 < vSpan) {
                                if (expandRow[i - k3]) {
                                    last = i - k3;
                                    heights[last] = heights[last] + delta;
                                }
                                ++k3;
                            }
                            if (last > -1) {
                                int n = last;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    int minimumHeight = data.getMinimumHeight();
                    if (!data.shouldGrabVerticalSpace() || minimumHeight != 0) {
                        int n = h = !data.shouldGrabVerticalSpace() || minimumHeight == -1 ? data.getCachedHeight() : minimumHeight;
                        if ((h += data.getTopMargin() + data.getBottomMargin() - spanMinHeight - (vSpan - 1) * this.mVSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n2 = i;
                                minHeights[n2] = minHeights[n2] + h;
                            } else {
                                int delta = h / spanExpandCount;
                                int remainder = h % spanExpandCount;
                                int last = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i - k]) {
                                        last = i - k;
                                        minHeights[last] = minHeights[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n3 = last;
                                    minHeights[n3] = minHeights[n3] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            int i2 = 0;
            while (i2 < this.mRowCount) {
                totalHeight += heights[i2];
                ++i2;
            }
            int c = expandCount;
            int delta = (availableHeight - totalHeight) / c;
            int remainder = (availableHeight - totalHeight) % c;
            int last = -1;
            while (totalHeight != availableHeight) {
                int i3 = 0;
                while (i3 < this.mRowCount) {
                    if (expandRow[i3]) {
                        if (heights[i3] + delta > minHeights[i3]) {
                            last = i3;
                            heights[last] = heights[i3] + delta;
                        } else {
                            heights[i3] = minHeights[i3];
                            expandRow[i3] = false;
                            --c;
                        }
                    }
                    ++i3;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i3 = 0;
                while (i3 < this.mRowCount) {
                    int j = 0;
                    while (j < this.mColumns) {
                        int vSpan;
                        PrecisionLayoutData data = this.getData(grid, i3, j, this.mRowCount, false);
                        if (data != null && (vSpan = Math.max(1, Math.min(data.getVerticalSpan(), this.mRowCount))) > 1) {
                            int minimumHeight = data.getMinimumHeight();
                            if (!data.shouldGrabVerticalSpace() || minimumHeight != 0) {
                                int h;
                                int spanHeight = 0;
                                int spanExpandCount = 0;
                                k = 0;
                                while (k < vSpan) {
                                    spanHeight += heights[i3 - k];
                                    if (expandRow[i3 - k]) {
                                        ++spanExpandCount;
                                    }
                                    ++k;
                                }
                                int n = h = !data.shouldGrabVerticalSpace() || minimumHeight == -1 ? data.getCachedHeight() : minimumHeight;
                                if ((h += data.getTopMargin() + data.getBottomMargin() - spanHeight - (vSpan - 1) * this.mVSpacing) > 0) {
                                    if (spanExpandCount == 0) {
                                        int n4 = i3;
                                        heights[n4] = heights[n4] + h;
                                    } else {
                                        int delta2 = h / spanExpandCount;
                                        int remainder2 = h % spanExpandCount;
                                        int last2 = -1;
                                        int k4 = 0;
                                        while (k4 < vSpan) {
                                            if (expandRow[i3 - k4]) {
                                                last2 = i3 - k4;
                                                heights[last2] = heights[last2] + delta2;
                                            }
                                            ++k4;
                                        }
                                        if (last2 > -1) {
                                            int n5 = last2;
                                            heights[n5] = heights[n5] + remainder2;
                                        }
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    ++i3;
                }
                if (c == 0) break;
                totalHeight = 0;
                i3 = 0;
                while (i3 < this.mRowCount) {
                    totalHeight += heights[i3];
                    ++i3;
                }
                delta = (availableHeight - totalHeight) / c;
                remainder = (availableHeight - totalHeight) % c;
                last = -1;
            }
        }
        return heights;
    }

    private final Block[][] buildGrid(Block[] children) {
        Block[][] grid = new Block[4][this.mColumns];
        int row = 0;
        int column = 0;
        this.mRowCount = 0;
        Block[] blockArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Block child = blockArray[n2];
            PrecisionLayoutData data = PrecisionLayout.getLayoutData(child);
            int hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns));
            int vSpan = Math.max(1, data.getVerticalSpan());
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Block[][] newGrid = new Block[lastRow + 4][this.mColumns];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Block[this.mColumns];
                }
                while (column < this.mColumns && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= this.mColumns) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < this.mColumns) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                int pos = row + j;
                if (grid[pos] == null) {
                    grid[pos] = new Block[this.mColumns];
                }
                int k = 0;
                while (k < hSpan) {
                    grid[pos][column + k] = child;
                    ++k;
                }
                ++j;
            }
            this.mRowCount = Math.max(this.mRowCount, row + vSpan);
            column += hSpan;
            ++n2;
        }
        return grid;
    }

    private final PrecisionLayoutData getData(Block[][] grid, int row, int column, int rowCount, boolean first) {
        Block component = grid[row][column];
        if (component != null) {
            int j;
            PrecisionLayoutData data = PrecisionLayout.getLayoutData(component);
            int hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns));
            int vSpan = Math.max(1, data.getVerticalSpan());
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < this.mColumns && component == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    private final Point layout(Block target, boolean move, int width, int height, boolean useMinimumSize) {
        Block[] children;
        int x = 0;
        int y = 0;
        int totalWidth = this.mMarginLeft + this.mMarginRight;
        int totalHeight = this.mMarginTop + this.mMarginBottom;
        if (this.mColumns > 0 && (children = PrecisionLayout.getChildren(target, useMinimumSize)).length > 0) {
            Block[][] grid = this.buildGrid(children);
            int[] widths = this.adjustColumnWidths(width, grid);
            this.wrap(width, grid, widths, useMinimumSize);
            int[] heights = this.adjustRowHeights(height, grid);
            totalWidth += this.mHSpacing * (this.mColumns - 1);
            totalHeight += this.mVSpacing * (this.mRowCount - 1);
            int i = 0;
            while (i < this.mColumns) {
                totalWidth += widths[i];
                ++i;
            }
            i = 0;
            while (i < this.mRowCount) {
                totalHeight += heights[i];
                ++i;
            }
            if (move) {
                if (totalWidth < width) {
                    if (this.mHAlign == 0x1000000) {
                        x += (width - totalWidth) / 2;
                    } else if (this.mHAlign == 131072) {
                        x += width - totalWidth;
                    }
                }
                if (totalHeight < height) {
                    if (this.mVAlign == 0x1000000) {
                        y += (height - totalHeight) / 2;
                    } else if (this.mVAlign == 131072) {
                        y += height - totalHeight;
                    }
                }
                this.positionChildren(x, y, grid, widths, heights);
            }
        }
        return new Point(totalWidth, totalHeight);
    }

    private final void positionChildren(int x, int y, Block[][] grid, int[] widths, int[] heights) {
        int gridY = y + this.mMarginTop;
        int i = 0;
        while (i < this.mRowCount) {
            int gridX = x + this.mMarginLeft;
            int j = 0;
            while (j < this.mColumns) {
                PrecisionLayoutData data = this.getData(grid, i, j, this.mRowCount, true);
                if (data != null) {
                    int hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns));
                    int vSpan = Math.max(1, data.getVerticalSpan());
                    int cellWidth = 0;
                    int cellHeight = 0;
                    int k = 0;
                    while (k < hSpan) {
                        cellWidth += widths[j + k];
                        ++k;
                    }
                    k = 0;
                    while (k < vSpan) {
                        cellHeight += heights[i + k];
                        ++k;
                    }
                    int childX = gridX + data.getLeftMargin();
                    int childWidth = Math.min(data.getCachedWidth(), cellWidth += this.mHSpacing * (hSpan - 1));
                    switch (data.getHorizontalAlignment()) {
                        case 0x1000000: {
                            childX += Math.max(0, (cellWidth - (data.getLeftMargin() + data.getRightMargin()) - childWidth) / 2);
                            break;
                        }
                        case 131072: {
                            childX += Math.max(0, cellWidth - (data.getLeftMargin() + data.getRightMargin()) - childWidth);
                            break;
                        }
                        case 4: {
                            childWidth = cellWidth - (data.getLeftMargin() + data.getRightMargin());
                            break;
                        }
                    }
                    int childY = gridY + data.getTopMargin();
                    int childHeight = Math.min(data.getCachedHeight(), cellHeight += this.mVSpacing * (vSpan - 1));
                    switch (data.getVerticalAlignment()) {
                        case 0x1000000: {
                            childY += Math.max(0, (cellHeight - (data.getTopMargin() + data.getBottomMargin()) - childHeight) / 2);
                            break;
                        }
                        case 131072: {
                            childY += Math.max(0, cellHeight - (data.getTopMargin() + data.getBottomMargin()) - childHeight);
                            break;
                        }
                        case 4: {
                            childHeight = cellHeight - (data.getTopMargin() + data.getBottomMargin());
                            break;
                        }
                    }
                    Block child = grid[i][j];
                    if (child != null) {
                        child.setBounds(childX, childY, childWidth, childHeight);
                    }
                }
                gridX += widths[j] + this.mHSpacing;
                ++j;
            }
            gridY += heights[i] + this.mVSpacing;
            ++i;
        }
    }

    private final void wrap(int width, Block[][] grid, int[] widths, boolean useMinimumSize) {
        if (width != -1) {
            int j = 0;
            while (j < this.mColumns) {
                int i = 0;
                while (i < this.mRowCount) {
                    PrecisionLayoutData data = this.getData(grid, i, j, this.mRowCount, false);
                    if (data != null && data.getHeightHint() == -1) {
                        int hSpan = Math.max(1, Math.min(data.getHorizontalSpan(), this.mColumns));
                        int currentWidth = 0;
                        int k = 0;
                        while (k < hSpan) {
                            currentWidth += widths[j - k];
                            ++k;
                        }
                        if ((currentWidth += (hSpan - 1) * this.mHSpacing - (data.getLeftMargin() + data.getRightMargin())) != data.getCachedWidth() && data.getHorizontalAlignment() == 4 || data.getCachedWidth() > currentWidth) {
                            data.computeSize(grid[i][j], Math.max(data.getCachedMinimumWidth(), currentWidth), -1, useMinimumSize);
                            int minimumHeight = data.getMinimumHeight();
                            if (data.shouldGrabVerticalSpace() && minimumHeight > 0) {
                                data.setCachedHeight(Math.max(data.getCachedHeight(), minimumHeight));
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
    }
}

