/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.IProvidesStateMaskAtMouseDown;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.IBlockContentProposalProvider;
import com.arm.utils.text.SWTLabelFilter;
import java.util.ArrayList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BlockComposite
extends Composite
implements IProvidesStateMaskAtMouseDown,
IControlContentAdapter,
IControlContentAdapter2,
IContentProposalProvider,
IContentProposalListener,
IContentProposalListener2,
ICommandTarget,
Listener,
ControlListener,
FocusListener,
KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
PaintListener,
TraverseListener {
    private BlockRoot mRoot = new BlockRoot(this);
    private Block mLastMouseBlock;
    private Block mMouseDownBlock;
    private Block mFocusBlock;
    private Block mFocusBlockWhenContentProposalStarted;
    private Block mFocusBlockAfterProposalAcceptance;
    private boolean mNeedFocusLost;
    private ContentProposalAdapter mContentProposalAdapter;
    private int mStateMaskAtMouseDown;

    public BlockComposite(Composite parent) {
        super(parent, 0x20040000);
        this.addControlListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addPaintListener(this);
        this.addTraverseListener(this);
        this.addListener(37, this);
        this.addListener(38, this);
        this.mContentProposalAdapter = new ContentProposalAdapter((Control)this, (IControlContentAdapter)this, (IContentProposalProvider)this, KeyStroke.getInstance((int)262144, (int)32), null);
        this.mContentProposalAdapter.addContentProposalListener((IContentProposalListener)this);
        this.mContentProposalAdapter.addContentProposalListener((IContentProposalListener2)this);
    }

    public final void applyCursor(Cursor cursor) {
        Cursor current;
        if (cursor == null) {
            cursor = this.getDisplay().getSystemCursor(0);
        }
        if ((current = this.getCursor()) != null ? !current.equals((Object)cursor) : cursor != null) {
            this.setCursor(cursor);
        }
    }

    public final Point computeSize(int widthHint, int heightHint, boolean changed) {
        return this.mRoot.getPreferredSize(widthHint, heightHint);
    }

    public final void controlMoved(ControlEvent event) {
    }

    public final void controlResized(ControlEvent event) {
        this.adjustToSizeChange();
    }

    public final void focusGained(FocusEvent event) {
        if (this.mFocusBlock == null) {
            ArrayList<Block> focusables = new ArrayList<Block>();
            this.mRoot.flattenFocusables(focusables);
            Block block = this.mFocusBlock = focusables.isEmpty() ? this.mRoot : (Block)focusables.get(0);
            if (this.mFocusBlock != null) {
                this.mFocusBlock.scrollIntoView(this.mFocusBlock.getFocusArea());
            }
        }
        this.notifyOfFocusGained(false);
    }

    public final void focusLost(FocusEvent event) {
        this.notifyOfFocusLost();
    }

    public final String getControlContents(Control control) {
        Block block = this.getProposalProviderBlock();
        return block != null ? block.getContentsForProposal() : null;
    }

    public final int getCursorPosition(Control control) {
        Block block = this.getProposalProviderBlock();
        return block != null ? block.getCursorPositionForProposal() : 0;
    }

    public final Block getFocus() {
        if (this.mFocusBlock != null && this.mFocusBlock.getOwner() != this) {
            this.mFocusBlock = null;
        }
        return this.mFocusBlock;
    }

    public final Rectangle getInsertionBounds(Control control) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            Rectangle bounds = block.getInsertionBoundsForProposal();
            this.mContentProposalAdapter.setPopupSize(new Point(bounds.width, bounds.height));
            Point location = control.getDisplay().map((Control)control.getParent(), null, control.getLocation());
            int x = location.x + 3 + bounds.x + block.getX();
            int y = location.y + bounds.y;
            Rectangle constrained = WidgetUtils.getConstrainedShellBounds(control.getDisplay(), new Rectangle(x, y, bounds.width, bounds.height));
            if (constrained.y < y) {
                bounds.y -= bounds.height + block.getHeight() + 3;
            }
            bounds.height = 0;
            return bounds;
        }
        return null;
    }

    public final Block getProposalProviderBlock() {
        return this.mFocusBlock != null && this.mFocusBlock.getContentProposalProvider() != null ? this.mFocusBlock : null;
    }

    public final IContentProposal[] getProposals(String contents, int position) {
        Block block = this.getProposalProviderBlock();
        return block != null ? block.getContentProposalProvider().getProposals(contents, position) : null;
    }

    public final BlockRoot getRoot() {
        return this.mRoot;
    }

    public final Point getSelection(Control control) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            return block.getCursorRangeForProposal();
        }
        return new Point(0, 0);
    }

    @Override
    public final int getStateMaskAtMouseDown() {
        return this.mStateMaskAtMouseDown;
    }

    public final void handleEvent(Event event) {
        if (event.doit && (event.type == 37 || event.type == 38)) {
            Block block = this.mRoot.findBlockAt(event.x, event.y, true);
            while (block != null) {
                if (!block.isEnabled()) {
                    block = block.getFirstEnabledParent();
                }
                if (block == null) continue;
                Point where = block.fromRoot(event.x, event.y);
                if (block.mouseScrolled(where, event.stateMask, event.count, event.type == 37)) {
                    this.applyToolTipText(block.getToolTip(where));
                    this.applyCursor(block.getCursor(where));
                    event.doit = false;
                    break;
                }
                block = block.getParent();
            }
        }
    }

    public final void insertControlContents(Control control, String contents, int cursorPosition) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            block.insertProposalContents(contents, cursorPosition);
        }
    }

    public final boolean isProposalPopupOpen() {
        return this.mContentProposalAdapter.isProposalPopupOpen();
    }

    public final void keyPressed(KeyEvent event) {
        this.validateFocus();
        Block target = this.mFocusBlock != null ? this.mFocusBlock : this.mRoot;
        while (target != null) {
            if (target.keyPressed(event.keyCode, event.character, event.keyLocation, event.stateMask)) {
                event.doit = false;
                break;
            }
            target = target.getParent();
        }
    }

    public final void keyReleased(KeyEvent event) {
        this.validateFocus();
        Block target = this.mFocusBlock != null ? this.mFocusBlock : this.mRoot;
        while (target != null) {
            if (target.keyReleased(event.keyCode, event.character, event.keyLocation, event.stateMask)) {
                event.doit = false;
                break;
            }
            target = target.getParent();
        }
    }

    public final void keyTraversed(TraverseEvent event) {
        if (event.detail == 8) {
            this.applyFocus(event, false);
        } else if (event.detail == 16) {
            this.applyFocus(event, true);
        }
    }

    public final void mouseDoubleClick(MouseEvent event) {
    }

    public final void mouseDown(MouseEvent event) {
        this.mStateMaskAtMouseDown = event.stateMask;
        Block block = this.mRoot.findBlockAt(event.x, event.y, true);
        this.deliverMouseEnterIfNeeded(event, block);
        if (block != null) {
            this.mMouseDownBlock = block;
            this.applyToolTipText(null);
            this.setCapture(true);
            if (block.isEnabled()) {
                if (block.isFocusable()) {
                    this.setFocus(block);
                } else if (block.removesOtherFocus()) {
                    this.setFocus(null);
                }
                block.mouseDown(block.fromRoot(event.x, event.y), event.button, event.stateMask, event.count);
            }
        }
    }

    public final void mouseEnter(MouseEvent event) {
        this.deliverMouseEnterIfNeeded(event, this.mRoot.findBlockAt(event.x, event.y, true));
    }

    public final void mouseExit(MouseEvent event) {
        if (this.mLastMouseBlock != null) {
            this.mLastMouseBlock.mouseExit();
            this.mLastMouseBlock = null;
        }
    }

    public final void mouseHover(MouseEvent event) {
        if (this.mMouseDownBlock != null) {
            Point where;
            if (this.mMouseDownBlock.isEnabled() && this.mMouseDownBlock.contains(where = this.mMouseDownBlock.fromRoot(event.x, event.y))) {
                this.mMouseDownBlock.mouseDragHover(where, event.button, event.stateMask);
            }
        } else {
            Block block = this.mRoot.findBlockAt(event.x, event.y, true);
            this.deliverMouseEnterIfNeeded(event, block);
            if (block != null) {
                block.mouseHover(block.fromRoot(event.x, event.y), event.stateMask);
            }
        }
    }

    public final void mouseMove(MouseEvent event) {
        if (this.mMouseDownBlock != null) {
            if (this.mMouseDownBlock.isEnabled()) {
                this.mMouseDownBlock.mouseDrag(this.mMouseDownBlock.fromRoot(event.x, event.y), event.button, event.stateMask);
            }
        } else {
            Block block = this.mRoot.findBlockAt(event.x, event.y, true);
            this.deliverMouseEnterIfNeeded(event, block);
            if (block != null) {
                Point where = block.fromRoot(event.x, event.y);
                block.mouseMove(where, event.stateMask);
                this.applyToolTipText(block.getToolTip(where));
                this.applyCursor(block.getCursor(where));
            }
        }
    }

    public final void mouseUp(MouseEvent event) {
        if (this.mMouseDownBlock != null) {
            if (this.mMouseDownBlock.isEnabled()) {
                this.mMouseDownBlock.mouseUp(this.mMouseDownBlock.fromRoot(event.x, event.y), event.button, event.stateMask, event.count);
            }
            this.mMouseDownBlock = null;
            this.setCapture(false);
        }
        this.deliverMouseEnterIfNeeded(event, this.mRoot.findBlockAt(event.x, event.y, true));
    }

    @Override
    public final void obeyCommand(CommandAction action) {
        Block target = this.mFocusBlock != null ? this.mFocusBlock : this.mRoot;
        while (target != null) {
            if (target.obeyCommand(action)) break;
            target = target.getParent();
        }
    }

    public final void paintControl(PaintEvent event) {
        GC gc = event.gc;
        gc.setAdvanced(true);
        gc.setTextAntialias(1);
        this.mRoot.paint(gc, event.x, event.y, event.width, event.height);
    }

    public void proposalAccepted(IContentProposal proposal) {
        if (this.mFocusBlockAfterProposalAcceptance != null) {
            this.setFocus(this.mFocusBlockAfterProposalAcceptance);
        }
        this.forceFocus();
    }

    public final void proposalPopupClosed(ContentProposalAdapter adapter) {
        if (this.mFocusBlockWhenContentProposalStarted != null && this.mNeedFocusLost) {
            this.mFocusBlockWhenContentProposalStarted.focusLost();
        }
        this.mFocusBlockAfterProposalAcceptance = this.mFocusBlockWhenContentProposalStarted;
        this.mFocusBlockWhenContentProposalStarted = null;
        this.mContentProposalAdapter.setEnabled(this.mFocusBlockAfterProposalAcceptance == this.mFocusBlock);
    }

    public final void proposalPopupOpened(ContentProposalAdapter adapter) {
        this.mFocusBlockWhenContentProposalStarted = this.mFocusBlock;
        this.mNeedFocusLost = false;
    }

    public final void releaseCapturedMouse() {
        if (this.mMouseDownBlock != null) {
            this.mMouseDownBlock = null;
            if (!this.isDisposed()) {
                this.setCapture(false);
            }
        }
    }

    public final void setControlContents(Control control, String contents, int cursorPosition) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            block.setProposalContents(contents, cursorPosition);
        }
    }

    public final void setCursorPosition(Control control, int index) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            block.setCursorPositionForProposal(index);
        }
    }

    public final void setFocus(Block focus) {
        if (this.mFocusBlock != focus) {
            this.notifyOfFocusLost();
        }
        if (focus != null) {
            if (this.mFocusBlock != focus) {
                this.mFocusBlock = focus;
                this.mFocusBlock.scrollIntoView(this.mFocusBlock.getFocusArea());
                this.notifyOfFocusGained(false);
            }
        } else {
            this.mFocusBlock = null;
        }
    }

    public final void setSelection(Control control, Point range) {
        Block block = this.getProposalProviderBlock();
        if (block != null) {
            block.setCursorRangeForProposal(range);
        }
    }

    private final void applyFocus(TraverseEvent event, boolean forward) {
        Block newFocus;
        ArrayList<Block> focusables = new ArrayList<Block>();
        this.mRoot.flattenFocusables(focusables);
        if (focusables.isEmpty()) {
            newFocus = this.mRoot;
        } else {
            int index = focusables.indexOf(this.mFocusBlock);
            if (index == -1) {
                index = forward ? 0 : focusables.size() - 1;
            } else if (forward) {
                if (++index >= focusables.size()) {
                    index = 0;
                }
            } else if (--index < 0) {
                index = focusables.size() - 1;
            }
            newFocus = (Block)focusables.get(index);
        }
        if (newFocus != this.mFocusBlock) {
            this.notifyOfFocusLost();
            if (newFocus != null) {
                event.doit = false;
                event.detail = 0;
                this.mFocusBlock = newFocus;
                this.mFocusBlock.scrollIntoView(this.mFocusBlock.getFocusArea());
                this.notifyOfFocusGained(true);
            } else {
                event.doit = true;
            }
        }
    }

    private final void applyToolTipText(String text) {
        text = SWTLabelFilter.filterForToolTip((String)text);
        String current = this.getToolTipText();
        if (current != null ? !current.equals(text) : text != null) {
            this.setToolTipText(text);
        }
    }

    private final void deliverMouseEnterIfNeeded(MouseEvent event, Block block) {
        if (this.mLastMouseBlock != block) {
            if (this.mLastMouseBlock != null) {
                this.mLastMouseBlock.mouseExit();
            }
            this.mLastMouseBlock = block;
            if (block != null) {
                Point where = block.fromRoot(event.x, event.y);
                block.mouseEnter(where, event.stateMask);
                this.applyToolTipText(block.getToolTip(where));
                this.applyCursor(block.getCursor(where));
            }
        }
    }

    private final void notifyOfFocusGained(boolean fromKeyboard) {
        if (this.mFocusBlock != null) {
            this.mFocusBlock.focusGained(fromKeyboard);
            IBlockContentProposalProvider provider = this.mFocusBlock.getContentProposalProvider();
            this.mContentProposalAdapter.setEnabled(provider != null);
            if (provider != null) {
                this.mContentProposalAdapter.setAutoActivationCharacters(provider.getAutoActivationCharacters());
            }
        }
    }

    private final void notifyOfFocusLost() {
        if (this.mFocusBlock != null) {
            if (this.isProposalPopupOpen()) {
                this.mNeedFocusLost = true;
            } else {
                this.mFocusBlock.focusLost();
            }
        }
    }

    private final void validateFocus() {
        if (this.mFocusBlock != null && this.mFocusBlock.getRoot() != this.mRoot) {
            this.mFocusBlock = null;
        }
    }

    final void adjustToSizeChange() {
        if (!this.isDisposed()) {
            Rectangle bounds = this.getClientArea();
            if (bounds.width > 0 && bounds.height > 0) {
                this.mRoot.setBounds(bounds);
            }
        }
    }
}

