/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ToolbarBadge
extends Canvas
implements PaintListener {
    private static final int MARGIN = 3;
    private Color mColor;
    private Image mImage;
    private String mText;

    public ToolbarBadge(Composite parent, Color color, Image image) {
        super(parent, 0x20000000);
        this.setFont(Fonts.getNormalStandout());
        this.addPaintListener(this);
        this.mColor = color;
        this.mImage = image;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        Rectangle bounds = this.mImage.getBounds();
        int width = 3 + bounds.width + 3;
        int n = height = hHint != -1 ? hHint : width;
        if (this.mText != null) {
            FontInfo info = FontInfo.get(this.getFont());
            Point extent = info.getExtent(this.mText);
            width += extent.x + 3;
            if (extent.y > height) {
                height = extent.y;
            }
        }
        return new Point(width, height);
    }

    public Image getImage() {
        return this.mImage;
    }

    public void paintControl(PaintEvent event) {
        GC gc = event.gc;
        Rectangle bounds = this.getClientArea();
        this.paintBackground(gc, bounds);
        Rectangle imgBounds = this.mImage.getBounds();
        if (this.mText != null) {
            FontInfo info = FontInfo.get(this.getFont());
            int x = bounds.x + 3 + imgBounds.width + 3;
            int y = bounds.y + (bounds.height - info.getHeight()) / 2;
            gc.setForeground(Colors.getBlack());
            TextDrawing.drawString(gc, this.mText, x - 1, y - 1, 16384);
            TextDrawing.drawString(gc, this.mText, x - 1, y, 16384);
            TextDrawing.drawString(gc, this.mText, x - 1, y + 1, 16384);
            TextDrawing.drawString(gc, this.mText, x, y - 1, 16384);
            TextDrawing.drawString(gc, this.mText, x, y + 1, 16384);
            TextDrawing.drawString(gc, this.mText, x + 1, y + 1, 16384);
            TextDrawing.drawString(gc, this.mText, x + 1, y, 16384);
            TextDrawing.drawString(gc, this.mText, x + 1, y - 1, 16384);
            gc.setForeground(Colors.getWhite());
            TextDrawing.drawString(gc, this.mText, x, y, 16384);
        }
        gc.drawImage(this.mImage, this.mText != null ? bounds.x + 3 : bounds.x + (bounds.width - imgBounds.width) / 2, bounds.y + (bounds.height - imgBounds.height) / 2);
    }

    public boolean setText(String text) {
        if (this.mText == null ? text != null : !this.mText.equals(text)) {
            this.mText = text;
            this.redraw();
            return true;
        }
        return false;
    }

    protected void paintBackground(GC gc, Rectangle bounds) {
        gc.setForeground(this.mColor);
        gc.setBackground(Colors.darken(this.mColor, 20));
        gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
    }
}

