/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.ImageButton;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.utils.Platform;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;

public class TextField
extends Composite
implements PaintListener,
ImageButton.IClickListener,
FocusListener,
ModifyListener {
    private static final int IMAGE_MARGIN = 1;
    private Color mEnabledBackground;
    private final Color validTextColour = Colors.getWidgetForeground();
    private final Color invalidTextColour = Colors.getRed();
    private int mDesiredMinimumTextWidth = 20;
    final @NonNull Text mTextField;
    @Nullable ImageButton mImageButton;
    private Set<IClickListener> mClickListeners = new HashSet<IClickListener>();
    private Set<IFieldModifiedListener> mFieldModifiedListeners = new HashSet<IFieldModifiedListener>();
    private String mWatermark;
    protected boolean mNotify = true;

    public TextField(Composite parent) {
        this(parent, 0);
    }

    public TextField(Composite parent, Image image) {
        this(parent, image, 0);
    }

    public TextField(Composite parent, Image image, int style) {
        this(parent, style);
        this.mImageButton = new ImageButton((Composite)this, image);
        this.mImageButton.addClickListener(this);
    }

    public TextField(Composite parent, int style) {
        super(parent, 0x20000000);
        super.setLayout((Layout)new TextFieldLayout());
        this.addPaintListener(this);
        if (((style &= 0x142404C) & 0x40) == 0) {
            style |= 4;
        }
        this.mTextField = new Text((Composite)this, style |= 0x20000800);
        this.mTextField.addModifyListener((ModifyListener)this);
        this.mTextField.addPaintListener((PaintListener)this);
        this.mEnabledBackground = Colors.create(this.mTextField.getBackground().getRGB());
        this.mTextField.addFocusListener((FocusListener)this);
        this.setCursor(this.getDisplay().getSystemCursor(19));
    }

    public synchronized void addClickListener(IClickListener listener) {
        this.mClickListeners.add(listener);
    }

    public synchronized void addFieldModifiedListener(IFieldModifiedListener listener) {
        this.mFieldModifiedListeners.add(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.mTextField.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.mTextField.addKeyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buttonClicked(ImageButton button) {
        IClickListener[] listeners;
        TextField textField = this;
        synchronized (textField) {
            listeners = this.mClickListeners.toArray(new IClickListener[this.mClickListeners.size()]);
        }
        IClickListener[] iClickListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IClickListener listener = iClickListenerArray[n2];
            listener.buttonClicked(this);
            ++n2;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        int width = this.getRecommendedMinimumWidth();
        if (size.x < width) {
            size.x = width;
        }
        return size;
    }

    public void copy() {
        this.mTextField.copy();
    }

    public void cut() {
        this.mTextField.cut();
    }

    public void focusGained(FocusEvent event) {
        SafeUpdate.redraw((Control)this);
    }

    public void focusLost(FocusEvent event) {
        SafeUpdate.redraw((Control)this);
    }

    public Font getFont() {
        return this.mTextField.getFont();
    }

    public String getImageToolTipText() {
        return this.mImageButton != null ? this.mImageButton.getToolTipText() : null;
    }

    public int getRecommendedMinimumWidth() {
        int width = this.mDesiredMinimumTextWidth;
        ImageButton imageButton = this.mImageButton;
        if (imageButton != null) {
            width += 1 + imageButton.computeSize((int)-1, (int)-1).x + 1;
        }
        return width;
    }

    public Point getSelection() {
        return this.mTextField.getSelection();
    }

    public int getSelectionCount() {
        return this.mTextField.getSelectionCount();
    }

    public String getSelectionText() {
        return this.mTextField.getSelectionText();
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public Color getTextBackground() {
        return this.mTextField.getBackground();
    }

    public Color getTextForeground() {
        return this.mTextField.getForeground();
    }

    public int getTextLimit() {
        return this.mTextField.getTextLimit();
    }

    public String getToolTipText() {
        return this.mTextField.getToolTipText();
    }

    public @NonNull Text getUnderlyingTextControl() {
        return this.mTextField;
    }

    public String getWatermark() {
        return this.mTextField.getMessage();
    }

    public boolean handleCommand(String command) {
        if (this.isFocused()) {
            if (command.equals(ActionFactory.SELECT_ALL.getId())) {
                this.selectAll();
                return true;
            }
            if (command.equals(ActionFactory.CUT.getId())) {
                this.cut();
                return true;
            }
            if (command.equals(ActionFactory.COPY.getId())) {
                this.copy();
                return true;
            }
            if (command.equals(ActionFactory.PASTE.getId())) {
                this.paste();
                return true;
            }
        }
        return false;
    }

    public boolean isFocused() {
        return this.mTextField.isFocusControl();
    }

    public boolean isReallyEnabled() {
        return this.mTextField.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyText(ModifyEvent event) {
        if (this.mNotify) {
            IFieldModifiedListener[] listeners;
            TextField textField = this;
            synchronized (textField) {
                listeners = this.mFieldModifiedListeners.toArray(new IFieldModifiedListener[this.mFieldModifiedListeners.size()]);
            }
            IFieldModifiedListener[] iFieldModifiedListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IFieldModifiedListener listener = iFieldModifiedListenerArray[n2];
                listener.fieldModified(this);
                ++n2;
            }
        }
    }

    public void paintControl(PaintEvent event) {
        GC gc = event.gc;
        Rectangle bounds = this.getClientArea();
        if (event.widget == this) {
            gc.setForeground(Colors.darken(this.isFocused() ? Colors.getListSelection() : Colors.getWidgetBackground(), 20));
        } else if (this.mWatermark != null && (this.mTextField.getStyle() & 4) == 0 && this.mTextField.getText().isEmpty()) {
            gc.setFont(this.mTextField.getFont());
            gc.setForeground(Colors.getDarkGray());
            TextDrawing.drawString(gc, this.mWatermark, bounds.x + 5, bounds.y);
        }
    }

    public void paste() {
        this.mTextField.paste();
    }

    public synchronized void removeClickListener(IClickListener listener) {
        this.mClickListeners.remove(listener);
    }

    public synchronized void removeFieldModifiedListener(IFieldModifiedListener listener) {
        this.mFieldModifiedListeners.remove(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.mTextField.removeFocusListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.mTextField.removeKeyListener(listener);
    }

    public void selectAll() {
        this.mTextField.selectAll();
    }

    public void setCompositeTipText(String tooltip) {
        super.setToolTipText(tooltip);
    }

    public void setDesiredMinimumTextWidth(int minimum) {
        this.mDesiredMinimumTextWidth = minimum;
    }

    public void setEnabled(boolean enabled) {
        if (!this.mTextField.isDisposed() && enabled != this.mTextField.isEnabled()) {
            Color color = enabled ? this.mEnabledBackground : Colors.getWidgetBackground();
            this.mTextField.setEnabled(enabled);
            ControlHacks.setBackground((Control)this.mTextField, color);
            if (this.mImageButton != null) {
                this.mImageButton.setEnabled(enabled);
            }
            SafeUpdate.redraw((Control)this);
        }
    }

    public void setFont(Font font) {
        this.mTextField.setFont(font);
    }

    public void setImageToolTipText(String tooltip) {
        if (this.mImageButton != null) {
            this.mImageButton.setToolTipText(tooltip);
        }
    }

    public void setLayout(Layout layout) {
    }

    public void setSelection(int start) {
        this.mTextField.setSelection(start);
    }

    public void setSelection(int start, int end) {
        this.mTextField.setSelection(start, end);
    }

    public void setSelection(Point selection) {
        this.mTextField.setSelection(selection);
    }

    public void setSelectionToEnd() {
        this.mTextField.setSelection(Integer.MAX_VALUE);
    }

    public void setSelectionToStart() {
        this.mTextField.setSelection(0);
    }

    public boolean setText(String text) {
        if (!this.mTextField.getText().equals(text)) {
            this.mTextField.setText(text);
            return true;
        }
        return false;
    }

    public void setTextBackground(Color color) {
        ControlHacks.setBackground((Control)this.mTextField, color);
        this.mEnabledBackground = Colors.create(this.mTextField.getBackground().getRGB());
        ControlHacks.setBackground((Control)this, this.mEnabledBackground);
    }

    public void setTextForeground(Color color) {
        this.mTextField.setForeground(color);
    }

    public void setTextLimit(int limit) {
        this.mTextField.setTextLimit(limit);
    }

    public void setToolTipText(String tooltip) {
        this.mTextField.setToolTipText(tooltip);
    }

    public void setValid(boolean valid) {
        this.setTextForeground(valid ? this.validTextColour : this.invalidTextColour);
    }

    public void setWatermark(String watermark) {
        this.mTextField.setMessage(watermark);
        this.mWatermark = watermark;
        SafeUpdate.redraw((Control)this);
    }

    public static interface IClickListener {
        public void buttonClicked(TextField var1);
    }

    public static interface IFieldModifiedListener {
        public void fieldModified(TextField var1);
    }

    class TextFieldLayout
    extends Layout {
        TextFieldLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point size = new Point(0, 0);
            if (TextField.this.mImageButton != null) {
                size = TextField.this.mImageButton.computeSize(-1, -1);
                size.x += 2;
                size.y += 2;
            }
            Point textSize = this.computeTextFieldSize(Math.max(wHint - size.x, -1));
            size.x += textSize.x;
            if (size.y < textSize.y) {
                size.y = textSize.y;
            }
            return size;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle bounds = TextField.this.getClientArea();
            int x = bounds.x;
            int adjustment = 0;
            ImageButton imageButton = TextField.this.mImageButton;
            if (imageButton != null) {
                Point imgSize = imageButton.computeSize(-1, -1);
                int imageHeight = Math.min(bounds.height, Math.max(imgSize.x, imgSize.y));
                imageButton.setBounds(x + bounds.width - (imgSize.x + 1), bounds.y + (bounds.height - imageHeight) / 2, imgSize.x, imageHeight);
                adjustment = 1 + imgSize.x + 1;
            }
            int width = bounds.width - adjustment;
            Point size = this.computeTextFieldSize(width);
            TextField.this.mTextField.setBounds(x, bounds.y + (bounds.height - size.y) / 2, width, size.y);
        }

        private Point computeTextFieldSize(int width) {
            Point size = TextField.this.mTextField.computeSize(width, -1, true);
            String text = TextField.this.mTextField.getText();
            switch (Platform.getPlatform()) {
                case MACINTOSH: {
                    int min;
                    if (!text.isEmpty() || size.y >= (min = FontInfo.get(TextField.this.mTextField.getFont()).getHeight() + 2)) break;
                    size.y = min;
                    break;
                }
                case WINDOWS: {
                    if (!text.endsWith("\n")) break;
                    TextField.this.mNotify = false;
                    Point selection = TextField.this.mTextField.getSelection();
                    TextField.this.mTextField.setText(text + " ");
                    size = TextField.this.mTextField.computeSize(width, -1, true);
                    TextField.this.mTextField.setText(text);
                    TextField.this.mTextField.setSelection(selection);
                    TextField.this.mNotify = true;
                    break;
                }
            }
            return size;
        }
    }
}

