/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.widget.IMouseWheelHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MouseWheelTracker
implements Listener {
    private boolean mEnabled = true;

    public static MouseWheelTracker create(Control control) {
        return new MouseWheelTracker(control);
    }

    private MouseWheelTracker(Control control) {
        control.addListener(37, (Listener)this);
        control.addListener(38, (Listener)this);
    }

    public void disable() {
        this.mEnabled = false;
    }

    public void enable() {
        this.mEnabled = true;
    }

    public void handleEvent(Event event) {
        if (this.mEnabled && event.doit && (event.type == 37 || event.type == 38)) {
            Control control = (Control)event.widget;
            control = this.getControlAt(control.toDisplay(event.x, event.y), (Control)control.getShell());
            while (control != null && !(control instanceof IMouseWheelHandler)) {
                control = control.getParent();
            }
            if (control instanceof IMouseWheelHandler) {
                ((IMouseWheelHandler)control).handleMouseWheel(event.type == 37, event.count);
            }
            event.doit = false;
        }
    }

    private Control getControlAt(Point displayPt, Control root) {
        if (root != null && root.isVisible()) {
            Point where = root.toControl(displayPt);
            if (where.x >= 0 && where.y >= 0) {
                Point size = root.getSize();
                if (where.x < size.x && where.y < size.y) {
                    if (root instanceof Composite) {
                        Control[] controlArray = ((Composite)root).getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            Control result = this.getControlAt(displayPt, child);
                            if (result != null) {
                                return result;
                            }
                            ++n2;
                        }
                    }
                    return root;
                }
            }
        }
        return null;
    }
}

