/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.widget.ISettableTitleImage;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.graphics.Image;

public final class BusyTabHelper
implements Runnable {
    private static final int NORMAL = -1;
    private static final int WAITING = -2;
    private static final int BUSY = 0;
    private ISettableTitleImage mSettable;
    private Image mNormalImage;
    private String mKey;
    private int mBusy = -1;
    private boolean mDisposed;
    private int mTimeout;
    private long mBusyTime;

    public BusyTabHelper(ISettableTitleImage settable, Image image) {
        this(settable, image, 0);
    }

    public BusyTabHelper(ISettableTitleImage settable, Image image, int timeout) {
        this.mSettable = settable;
        this.mNormalImage = image;
        this.mKey = Task.getNextUniqueKey();
        this.mTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        BusyTabHelper busyTabHelper = this;
        synchronized (busyTabHelper) {
            this.mDisposed = true;
        }
    }

    public synchronized boolean isBusy() {
        return this.mBusy != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean scheduleAgain;
        Image image;
        BusyTabHelper busyTabHelper = this;
        synchronized (busyTabHelper) {
            long now;
            if (this.mBusy == -2 && this.mBusyTime + (long)this.mTimeout < (now = System.currentTimeMillis())) {
                this.mBusy = 0;
            }
            if (this.mBusy == -1) {
                image = this.mNormalImage;
                scheduleAgain = false;
            } else if (this.mBusy == -2) {
                image = this.mNormalImage;
                scheduleAgain = true;
            } else {
                image = StreamlinePlugin.getBusyImage(this.mBusy++);
                scheduleAgain = true;
            }
        }
        this.mSettable.setTitleImage(image);
        if (scheduleAgain) {
            Task.scheduleOnUIThread((Runnable)this, (String)this.mKey, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBusy(boolean busy) {
        boolean execute = false;
        BusyTabHelper busyTabHelper = this;
        synchronized (busyTabHelper) {
            if (!this.mDisposed && (busy && this.mBusy == -1 || !busy && this.mBusy != -1)) {
                if (busy) {
                    this.mBusy = -2;
                    this.mBusyTime = System.currentTimeMillis();
                } else {
                    this.mBusy = -1;
                    this.mBusyTime = 0L;
                }
                execute = true;
            }
        }
        if (execute) {
            Task.scheduleOnUIThread((Runnable)this, (String)(this.mBusyTime == 0L ? null : this.mKey), (long)0L, (TimeUnit)TimeUnit.MICROSECONDS);
        }
    }
}

