/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.widget.DirectScrollCanvas;
import com.arm.streamline.widget.IAutoScrollArea;
import com.arm.streamline.widget.IAutoScrollSpeed;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Slider;

public class AutoScroller
implements MouseListener,
MouseMoveListener,
FocusListener,
Runnable {
    public static final int INTERVAL = 150;
    private Scrollable mScrollable;
    private boolean mInMouseDown;
    private boolean mPending;
    private boolean mEnabled;

    public static AutoScroller create(Scrollable scrollable) {
        return new AutoScroller(scrollable);
    }

    private static boolean adjustBar(ScrollBar bar, int delta) {
        if (bar != null) {
            bar.setSelection(bar.getSelection() + delta);
            bar.setMaximum(bar.getMaximum());
            return true;
        }
        return false;
    }

    private static boolean adjustSlider(Slider slider, int delta) {
        if (slider != null) {
            slider.setSelection(slider.getSelection() + delta);
            slider.setMaximum(slider.getMaximum());
            return true;
        }
        return false;
    }

    private AutoScroller(Scrollable scrollable) {
        this.mScrollable = scrollable;
        this.mEnabled = true;
        this.mScrollable.addMouseListener((MouseListener)this);
        this.mScrollable.addMouseMoveListener((MouseMoveListener)this);
        this.mScrollable.addFocusListener((FocusListener)this);
    }

    public void disable() {
        this.mEnabled = false;
        this.mInMouseDown = false;
    }

    public void enable() {
        this.mEnabled = true;
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.mEnabled) {
            this.mInMouseDown = false;
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.mEnabled && event.button == 1) {
            this.mInMouseDown = this.mScrollable instanceof IAutoScrollArea ? ((IAutoScrollArea)this.mScrollable).isAutoScrollMouseDown(event.x, event.y) : this.getScrollArea().contains(event.x, event.y);
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.mEnabled && !this.mPending) {
            this.mPending = true;
            Task.scheduleOnUIThread((Runnable)this, null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.mEnabled) {
            this.mInMouseDown = false;
        }
    }

    @Override
    public void run() {
        if (this.mEnabled && this.mInMouseDown && !this.mScrollable.isDisposed()) {
            Rectangle bounds = this.getScrollArea();
            Point pt = this.mScrollable.toDisplay(bounds.x, bounds.y);
            bounds.x = pt.x;
            bounds.y = pt.y;
            Display display = this.mScrollable.getDisplay();
            pt = display.getCursorLocation();
            if (!bounds.contains(pt)) {
                int xd = this.delta(pt.x, bounds.x, bounds.x + bounds.width);
                int yd = this.delta(pt.y, bounds.y, bounds.y + bounds.height);
                if (xd != 0 || yd != 0) {
                    boolean needRedraw;
                    if (this.mScrollable instanceof DirectScrollCanvas) {
                        DirectScrollCanvas canvas = (DirectScrollCanvas)this.mScrollable;
                        needRedraw = AutoScroller.adjustSlider(canvas.getVerticalSlider(), yd);
                        needRedraw |= AutoScroller.adjustSlider(canvas.getHorizontalSlider(), xd);
                    } else {
                        needRedraw = AutoScroller.adjustBar(this.mScrollable.getVerticalBar(), yd);
                        needRedraw |= AutoScroller.adjustBar(this.mScrollable.getHorizontalBar(), xd);
                    }
                    if (needRedraw) {
                        this.mScrollable.redraw();
                        this.postMouseMove(bounds, pt);
                    }
                }
            }
            Task.scheduleOnUIThread((Runnable)this, null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            this.mPending = false;
        }
    }

    public void setMousePosition(int x, int y) {
        if (this.mEnabled) {
            this.mInMouseDown = this.mScrollable instanceof IAutoScrollArea ? ((IAutoScrollArea)this.mScrollable).isAutoScrollMouseDown(x, y) : this.getScrollArea().contains(x, y);
        }
    }

    private int delta(int current, int min, int max) {
        int value = 0;
        if (current < min) {
            value = current - min;
        } else if (current >= max) {
            value = current - max;
        }
        if (this.mScrollable instanceof IAutoScrollSpeed) {
            max = ((IAutoScrollSpeed)this.mScrollable).getMaximumAutoScrollSpeed();
            if (value > max) {
                value = max;
            } else if (value < -max) {
                value = -max;
            }
        }
        return value;
    }

    private Rectangle getScrollArea() {
        return this.mScrollable instanceof IAutoScrollArea ? ((IAutoScrollArea)this.mScrollable).getAutoScrollArea() : this.mScrollable.getClientArea();
    }

    private void postMouseMove(Rectangle bounds, Point pt) {
        pt = new Point(pt.x, pt.y);
        if (pt.x < bounds.x) {
            pt.x = bounds.x;
        } else if (pt.x >= bounds.x + bounds.width) {
            pt.x = bounds.x + bounds.width - 1;
        }
        if (pt.y < bounds.y) {
            pt.y = bounds.y;
        } else if (pt.y >= bounds.y + bounds.height) {
            pt.y = bounds.y + bounds.height - 1;
        }
        pt = this.mScrollable.toControl(pt);
        Event event = new Event();
        event.type = 5;
        event.x = pt.x;
        event.y = pt.y;
        this.mScrollable.notifyListeners(5, event);
    }
}

