/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IntegerRange {
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    private static final String DASH = "-";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Integer> parseString(@Nullable String string) throws Exception {
        String[] ranges;
        @NonNull ArrayList<Integer> result = new ArrayList<Integer>();
        if (string == null) return result.stream().distinct().collect(Collectors.toList());
        @NonNull String s = (String)NullChecking.neverNull((Object)string.trim());
        if (s.equals(EMPTY)) {
            return result;
        }
        if (s.startsWith(DASH) || s.startsWith(COMMA)) {
            throw new Exception();
        }
        if (s.endsWith(DASH) || s.endsWith(COMMA)) {
            throw new Exception();
        }
        String[] stringArray = ranges = s.split("\\s*,\\s*");
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            String range = stringArray[n2];
            if ((range = range.trim()).equals(EMPTY)) throw new Exception();
            if (range.contains(DASH)) {
                String[] startstop = range.split("\\s*-\\s*");
                if (startstop.length != 2) throw new Exception();
                Integer start = IntegerRange.parseUnsignedDecimalOrHex(startstop[0]);
                Integer end = IntegerRange.parseUnsignedDecimalOrHex(startstop[1]);
                if (end < start) throw new Exception();
                int i = start;
                while (i <= end) {
                    result.add((Integer)NullChecking.neverNull((Object)i));
                    ++i;
                }
            } else {
                result.add(IntegerRange.parseUnsignedDecimalOrHex(range));
            }
            ++n2;
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private static @NonNull Integer parseUnsignedDecimalOrHex(String string) {
        if (string.startsWith("0x")) {
            return (Integer)NullChecking.neverNull((Object)Integer.parseUnsignedInt(string.replace("0x", EMPTY), 16));
        }
        return (Integer)NullChecking.neverNull((Object)Integer.parseUnsignedInt(string));
    }

    public static @NonNull String asRangedList(List<Integer> values, int radix) {
        if (values != null && values.size() > 0) {
            values = values.stream().sorted().collect(Collectors.toList());
            ArrayList<Range> ranges = new ArrayList<Range>();
            Range currentRange = null;
            class Range {
                public Integer from;
                public Integer to;
                private final /* synthetic */ int val$radix;

                Range(int n) {
                    this.val$radix = n;
                }

                public String toString() {
                    Object toS;
                    Object fromS = this.val$radix == 16 ? "0x" + Integer.toHexString(this.from) : Integer.toString(this.from);
                    Object object = toS = this.val$radix == 16 ? "0x" + Integer.toHexString(this.to) : Integer.toString(this.to);
                    if (this.to == this.from + 1) {
                        return String.format("%s, %s", fromS, toS);
                    }
                    if (this.to > this.from) {
                        return String.format("%s-%s", fromS, toS);
                    }
                    return String.format("%s", fromS);
                }
            }
            currentRange = new Range(radix);
            currentRange.from = values.get(0);
            currentRange.to = values.size() > 1 ? values.get(0) : values.get(0);
            int j = 1;
            while (j < values.size()) {
                @NonNull Integer i = (Integer)NullChecking.neverNull((Object)values.get(j));
                if (currentRange.to + 1 == i) {
                    currentRange.to = i;
                } else {
                    ranges.add(currentRange);
                    currentRange = new Range(radix);
                    currentRange.from = i;
                    currentRange.to = i;
                }
                ++j;
            }
            ranges.add(currentRange);
            ArrayList<String> rangesAsString = new ArrayList<String>();
            for (Range range : ranges) {
                rangesAsString.add(range.toString());
            }
            return (String)NullChecking.neverNull((Object)String.join((CharSequence)", ", rangesAsString));
        }
        return EMPTY;
    }
}

