/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IOMessages;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingSupplier;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamlineFileUtils
extends CommonFileUtils {
    private static final long RETRY_TIME_LIMIT_NS = 3000000000L;

    public static @Nullable Future<@NonNull List<@NonNull File>> deleteAsynchronously(@NonNull File path) throws IOException {
        return StreamlineFileUtils.deleteAsynchronously(path, true);
    }

    public static @Nullable Future<@NonNull List<@NonNull File>> deleteAsynchronously(@NonNull File path, boolean moveFirst) throws IOException {
        File pathToDelete;
        File file = pathToDelete = moveFirst ? StreamlineFileUtils.prepareForDelete(path) : path;
        if (pathToDelete != null) {
            return CompletableFuture.supplyAsync(() -> StreamlineFileUtils.delete((File)pathToDelete));
        }
        return null;
    }

    public static @Nullable File prepareForDelete(@NonNull File path) throws IOException {
        if (path.exists()) {
            return (File)StreamlineFileUtils.ioOperationWithRetry(() -> StreamlineFileUtils.tryPrepareForDelete(path));
        }
        return null;
    }

    private static @NonNull File formatDeletePath(@NonNull File path, @Nullable Integer counter) {
        String name = (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)path.getName(), (boolean)false));
        int length = name.length();
        if (length > 60) {
            name = name.substring(0, 60);
        }
        File parent = path.getParentFile();
        if (counter == null) {
            return new File(parent, name + ".del");
        }
        return new File(parent, name + "_" + String.valueOf(counter) + ".del");
    }

    private static @Nullable File tryPrepareForDelete(@NonNull File path) throws IOException {
        int counter = 2;
        File newPath = StreamlineFileUtils.formatDeletePath(path, null);
        while (!path.renameTo(newPath)) {
            if (!path.exists()) {
                return null;
            }
            if (!newPath.exists()) {
                throw new IOException(MessageFormat.format(IOMessages.RENAME_FAILED, path));
            }
            newPath = StreamlineFileUtils.formatDeletePath(path, counter++);
        }
        return newPath;
    }

    public static void unixifyLineEndings(@NonNull File temp) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(temp.getAbsolutePath(), new String[0]));
        String content = new String(bytes, StandardCharsets.UTF_8);
        content = content.replaceAll("\\r\\n", "\n");
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataOutputStream d = new DataOutputStream(new FileOutputStream(temp));){
            d.writeBytes(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> @NonNull T ioOperationWithRetry(@NonNull IThrowingSupplier<@NonNull T, IOException> ioSupplier) throws IOException {
        long startTime = System.nanoTime();
        while (true) {
            try {
                return (T)ioSupplier.get();
            }
            catch (IOException e) {
                if (System.nanoTime() - startTime > 3000000000L) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
                continue;
            }
            break;
        }
    }
}

