/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Messages
extends Properties {
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private Class<?> mClass;
    private String mBundleName;
    private Map<String, Field> mFields = new HashMap<String, Field>();
    private Set<Object> mAlreadyMapped = new HashSet<Object>();
    private boolean mIsPrimary;

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    public static final void localize() {
        try {
            Messages.localize(Class.forName(new Exception().getStackTrace()[1].getClassName()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public static final void localize(Class<?> theClass) {
        Messages msgs = new Messages(theClass);
        msgs.load();
        msgs.fillInMissingValuesWithPlaceholders();
    }

    private static final List<String> getVariants(String bundleName) {
        String root = bundleName.replace('.', '/');
        String nl = Locale.getDefault().toString();
        ArrayList<String> variants = new ArrayList<String>(4);
        while (true) {
            variants.add(root + "_" + nl + ".properties");
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        variants.add(root + ".properties");
        return variants;
    }

    private Messages(Class<?> theClass) {
        Field[] fieldArray;
        this.mClass = theClass;
        this.mBundleName = this.mClass.getName();
        Field[] fieldArray2 = fieldArray = theClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            String name = field.getName();
            if (field.getType() == String.class && (field.getModifiers() & 0x19) == 9) {
                this.mFields.put(name, field);
            }
            ++n2;
        }
    }

    @Override
    public final synchronized Object put(Object key, Object value) {
        Field field = this.mFields.remove(key);
        if (field != null) {
            this.mAlreadyMapped.add(key);
            try {
                field.set(null, value);
            }
            catch (Exception exception) {
                System.err.println("Unable to set value of localized message for '" + String.valueOf(key) + "' in " + this.mBundleName);
            }
        } else if (this.mIsPrimary && !this.mAlreadyMapped.contains(key)) {
            System.err.println("Unused localized message for '" + String.valueOf(key) + "' in " + this.mBundleName);
        }
        return null;
    }

    private final void fillInMissingValuesWithPlaceholders() {
        for (Field field : this.mFields.values()) {
            String name = field.getName();
            System.err.println("Missing localized message for '" + name + "' in " + this.mBundleName);
            try {
                field.set(null, "*!*" + name + "*!*");
            }
            catch (Exception exception) {
                System.err.println("Unable to set default value of localized message for '" + name + "' in " + this.mBundleName);
            }
        }
    }

    private final void load() {
        ClassLoader loader = this.mClass.getClassLoader();
        List<String> variants = Messages.getVariants(this.mBundleName);
        if (!variants.isEmpty()) {
            int count = variants.size();
            int i = 0;
            while (i < count) {
                block17: {
                    String variant = variants.get(i);
                    try {
                        try {
                            Throwable throwable = null;
                            Object var7_9 = null;
                            try (InputStream input = loader == null ? ClassLoader.getSystemResourceAsStream(variant) : loader.getResourceAsStream(variant);){
                                if (input != null) {
                                    this.mIsPrimary = i == count - 1;
                                    this.load(input);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException exception) {
                            System.err.println("Error: Unable to load " + variant);
                            exception.printStackTrace(System.err);
                            this.clear();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.clear();
                        throw throwable;
                    }
                    this.clear();
                }
                ++i;
            }
        }
    }
}

