/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.utility.io.ImageUtils;
import com.arm.utils.collections.LRUCache;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.graphics.Image;

public class ImageCache
implements Runnable {
    private LRUCache<File, Image> mCache;
    private Set<File> mBadFiles = new HashSet<File>();
    private IImageCacheListener mListener;
    private BlockingQueue<File> mQueue = new LinkedBlockingQueue<File>();
    private Set<File> mLoading = new HashSet<File>();
    private Thread mThread;

    public ImageCache(int maxEntries, IImageCacheListener listener) {
        this.mCache = new LRUCache<File, Image>(maxEntries){

            protected boolean removeEldestEntry(Map.Entry<File, Image> eldest) {
                if (super.removeEldestEntry(eldest)) {
                    Image img = eldest.getValue();
                    Task.callOnUIThread(() -> img.dispose());
                    return true;
                }
                return false;
            }
        };
        this.mListener = listener;
        this.mThread = new Thread((Runnable)this, "Image Cache");
        this.mThread.setDaemon(true);
        this.mThread.setPriority(4);
        this.mThread.start();
    }

    public final void dispose() {
        this.mThread.interrupt();
    }

    public final Image get(File file) {
        return this.get(file, false);
    }

    public final synchronized Image get(File file, boolean forceLoadNowIfPossible) {
        if (this.mBadFiles.contains(file)) {
            return StreamlinePlugin.getImage("ImageError.png");
        }
        Image img = (Image)this.mCache.get((Object)file);
        if (img == null) {
            if (forceLoadNowIfPossible && !this.mLoading.contains(file)) {
                img = ImageUtils.load(file.getAbsolutePath());
                if (img == null) {
                    this.mBadFiles.add(file);
                } else {
                    this.mCache.put((Object)file, (Object)img);
                }
            }
            if (img == null) {
                if (this.mLoading.add(file)) {
                    this.mQueue.add(file);
                }
                img = StreamlinePlugin.getImage("VisualAnnotationLoadingPattern.png");
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (!Thread.interrupted()) {
            try {
                File file2 = this.mQueue.poll(1L, TimeUnit.DAYS);
                if (file2 == null) continue;
                Image img = ImageUtils.load(file2.getAbsolutePath());
                ImageCache imageCache = this;
                synchronized (imageCache) {
                    if (img == null) {
                        this.mBadFiles.add(file2);
                    } else {
                        this.mCache.put((Object)file2, (Object)img);
                    }
                    this.mLoading.remove(file2);
                }
                try {
                    this.mListener.imageWasLoaded(file2);
                }
                catch (Throwable throwable) {
                    CommonPlugin.error((Throwable)throwable);
                }
            }
            catch (InterruptedException exception) {
                break;
            }
        }
        this.mCache.forEach((file, image) -> image.dispose());
    }

    public static interface IImageCacheListener {
        public void imageWasLoaded(File var1);
    }
}

