/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class GPUImageDescriptor
extends ImageDescriptor {
    private final String mPath;

    private static String getDataID(DataInputStream in) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < 4) {
            int ch = in.read();
            if (ch == -1) break;
            buffer.append((char)ch);
            ++i;
        }
        return buffer.toString();
    }

    public GPUImageDescriptor(String path) {
        this.mPath = path;
    }

    public ImageData getImageData() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (LittleEndianDataInputStream in = new LittleEndianDataInputStream(this.mPath);){
                if (GPUImageDescriptor.getDataID((DataInputStream)in).equals("GPU1")) {
                    int formatStructSize = in.readLEInt();
                    if (formatStructSize != 24) {
                        throw new IOException("Incorrect GPU image format");
                    }
                    short width = in.readLEShort();
                    short height = in.readLEShort();
                    int bitsPerPixel = in.readLEInt();
                    int maskRed = in.readInt();
                    int maskGreen = in.readInt();
                    int maskBlue = in.readInt();
                    in.readInt();
                    int dataLength = bitsPerPixel / 8 * width * height;
                    byte[] imageBytes = new byte[dataLength];
                    in.readFully(imageBytes);
                    PaletteData paletteData = new PaletteData(maskRed, maskGreen, maskBlue);
                    return new ImageData((int)width, (int)height, bitsPerPixel, paletteData, 1, imageBytes);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

