/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression;

import com.arm.streamline.utility.expression.EvaluationException;
import com.arm.streamline.utility.expression.Evaluator;
import com.arm.streamline.utility.expression.ExpressionMessages;
import com.arm.streamline.utility.expression.operator.Operator;

class ExpressionTree {
    private Evaluator mEvaluator;
    private Object mLeftOperand;
    private Object mRightOperand;
    private Operator mOperator;
    private Operator mUnaryOperator;

    ExpressionTree(Evaluator evaluator, Object leftOperand, Object rightOperand, Operator operator, Operator unaryOperator) {
        this.mEvaluator = evaluator;
        this.mLeftOperand = leftOperand;
        this.mRightOperand = rightOperand;
        this.mOperator = operator;
        this.mUnaryOperator = unaryOperator;
    }

    final Object evaluate() throws EvaluationException {
        Object left = this.mEvaluator.evaluateOperand(this.mLeftOperand);
        Object right = this.mEvaluator.evaluateOperand(this.mRightOperand);
        if (this.mLeftOperand != null && this.mRightOperand != null) {
            Object result = this.mOperator.evaluate(left, right);
            return this.mUnaryOperator != null ? this.mUnaryOperator.evaluate(result) : result;
        }
        Object operand = this.mLeftOperand != null && this.mRightOperand == null ? left : (this.mLeftOperand == null && this.mRightOperand != null ? right : null);
        if (operand != null) {
            if (this.mUnaryOperator != null) {
                operand = this.mUnaryOperator.evaluate(operand);
            } else if (this.mOperator != null) {
                operand = this.mOperator.evaluate(operand);
            }
        }
        if (operand == null) {
            throw new EvaluationException(ExpressionMessages.INVALID_EXPRESSION);
        }
        return operand;
    }
}

