/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.streamline.utility.IUIStringProvider;
import com.arm.streamline.widget.TextField;
import com.arm.utils.text.SWTLabelFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class SWTUtils {
    public static <T> List<T> addAllCombo(Combo combo, @NonNull T @NonNull [] values, @Nullable T defaultSelection, Function<T, String> makeLabel) {
        int defaultIndex = -1;
        ArrayList<T> validValues = new ArrayList<T>();
        ArrayList<String> items = new ArrayList<String>();
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            String name = makeLabel.apply(value);
            if (name != null) {
                validValues.add(value);
                items.add(name);
                combo.setData(name, value);
                if (defaultSelection != null && value.equals(defaultSelection)) {
                    defaultIndex = items.size() - 1;
                }
            }
            ++n2;
        }
        combo.setData(validValues);
        combo.setItems(items.toArray(new String[items.size()]));
        combo.setVisibleItemCount(combo.getItemCount());
        combo.select(defaultIndex);
        return validValues;
    }

    public static @NonNull Spinner addSpinner(Composite parent, int min, int max, String title, String tooltip, SelectionListener listener) {
        Label label = new Label(parent, 16384);
        label.setText(title);
        label.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        Spinner result = new Spinner(parent, 2048);
        GridDataFactory.fillDefaults().minSize(25, -1).hint(50, -1).align(16384, 0x1000000).applyTo((Control)result);
        result.setMinimum(min);
        result.setMaximum(max);
        result.setSelection(min);
        result.addSelectionListener(listener);
        return result;
    }

    public static @NonNull Button createCheckbox(Composite parent, String title, String tooltip, SelectionListener listener) {
        Button button = new Button(parent, 32);
        button.setText(title);
        button.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        button.addSelectionListener(listener);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)button);
        return button;
    }

    public static @NonNull Combo createCombo(Composite parent, String tooltip, @NonNull Object @NonNull [] values, @NonNull SelectionListener listener) {
        return SWTUtils.createCombo(parent, tooltip, values, listener, new ArrayList<Object>());
    }

    public static @NonNull Combo createCombo(Composite parent, String tooltip, @NonNull Object @NonNull [] values, @NonNull SelectionListener listener, @NonNull List<Object> validValues) {
        @NonNull IUIStringProvider defaultStringProvider = new IUIStringProvider(){

            @Override
            public String getUIString(Object o) {
                return o.toString();
            }
        };
        return SWTUtils.createCombo(parent, tooltip, values, listener, defaultStringProvider, validValues);
    }

    public static <T> @NonNull Combo createCombo(Composite parent, String tooltip, @NonNull T @NonNull [] values, @NonNull SelectionListener listener, @NonNull IUIStringProvider stringProvider, @NonNull List<T> validValues) {
        Combo combo = SWTUtils.createCombo(parent, tooltip, values, stringProvider, validValues);
        combo.addSelectionListener(listener);
        return combo;
    }

    public static <T> @NonNull Combo createCombo(Composite parent, String tooltip, @NonNull T @NonNull [] values, @NonNull IUIStringProvider stringProvider, @NonNull List<T> validValues) {
        Combo combo = new Combo(parent, 8);
        combo.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        validValues.addAll(SWTUtils.addAllCombo(combo, values, null, t -> stringProvider.getUIString(t)));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)combo);
        return combo;
    }

    public static @NonNull Label createLabel(Composite parent, String title, String tooltip, int indent) {
        return SWTUtils.createLabel(parent, title, tooltip, indent, 16384);
    }

    public static @NonNull Label createLabel(Composite parent, String title, String tooltip, int indent, int style) {
        Label label = new Label(parent, style);
        label.setText(title);
        label.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).indent(indent, 0).applyTo((Control)label);
        return label;
    }

    public static TextField createTextField(Composite parent, String tooltip, String watermark) {
        TextField field = new TextField(parent);
        field.setToolTipText(tooltip);
        field.setWatermark(watermark);
        GridDataFactory.fillDefaults().minSize(50, -1).hint(100, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)field);
        return field;
    }

    public static <T> @Nullable T getComboSelectionObject(@NonNull Combo combo, @NonNull Class<T> clazz) {
        Object object;
        @Nullable Object data = combo.getData();
        @Nullable List values = data instanceof List ? (List)data : null;
        int selectionIndex = combo.getSelectionIndex();
        String label = combo.getItem(selectionIndex);
        if (values != null && selectionIndex >= 0 && selectionIndex < values.size() && (object = values.get(selectionIndex)) != null && clazz.isInstance(object)) {
            Object result = object;
            return (T)result;
        }
        Object dataLabel = combo.getData(label);
        if (dataLabel != null && clazz.isInstance(dataLabel)) {
            Object result = dataLabel;
            return (T)result;
        }
        return null;
    }

    public static String wrap(@NonNull String inputStr, int maxLineLength) {
        StringTokenizer strTkn = new StringTokenizer(inputStr, " ");
        StringBuilder output = new StringBuilder(inputStr.length());
        int lineLen = 0;
        while (strTkn.hasMoreTokens()) {
            String word = strTkn.nextToken();
            while (word.length() > maxLineLength) {
                output.append(word.substring(0, maxLineLength - lineLen)).append('\n');
                word = word.substring(maxLineLength - lineLen);
                lineLen = 0;
            }
            if (lineLen + word.length() > maxLineLength) {
                output.append('\n');
                lineLen = 0;
            }
            output.append(word).append(' ');
            lineLen += word.length() + 1;
        }
        return output.toString();
    }
}

