/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility;

import com.arm.utils.text.BasicNumberUtils;
import java.text.MessageFormat;

public class Debug {
    private long mStartTime;
    private long mPausedAt;
    private boolean mPaused;

    public static String convertThrowableToClickableEclipseConsoleString(Throwable throwable) {
        return Debug.convertThrowableToClickableEclipseConsoleString(throwable, true);
    }

    public static String convertThrowableToClickableEclipseConsoleString(Throwable throwable, boolean onlyShowARM) {
        StringBuilder builder = new StringBuilder();
        boolean appendSeparator = false;
        builder.append(throwable.getClass().getSimpleName());
        builder.append(": ");
        String message = throwable.getMessage();
        if (message != null) {
            builder.append(message);
            builder.append(": ");
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean include;
            StackTraceElement element = stackTraceElementArray[n2];
            boolean bl = include = !onlyShowARM;
            if (!include) {
                String className = element.getClassName();
                boolean bl2 = include = className.startsWith("com.arm") && !className.equals(Debug.class.getCanonicalName());
            }
            if (include) {
                if (appendSeparator) {
                    builder.append(" < ");
                } else {
                    appendSeparator = true;
                }
                builder.append('(');
                builder.append(element.getFileName());
                builder.append(':');
                builder.append(element.getLineNumber());
                builder.append(')');
            }
            ++n2;
        }
        return builder.toString();
    }

    public static final String getCaller() {
        return Debug.getCaller(1, true);
    }

    public static final String getCaller(boolean onlyConsiderARM) {
        return Debug.getCaller(1, onlyConsiderARM);
    }

    public static final String getCaller(int upCount) {
        return Debug.getCaller(upCount, true);
    }

    public static final String getCaller(int upCount, boolean onlyConsiderARM) {
        Exception ex = new Exception();
        ex.fillInStackTrace();
        StackTraceElement[] stackTrace = ex.getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            if ((!onlyConsiderARM || onlyConsiderARM && stackTrace[i].getClassName().startsWith("com.arm")) && upCount-- <= 0) {
                return stackTrace[i].toString();
            }
            ++i;
        }
        return "Unknown";
    }

    public static String getCurrentContextAsClickableEclipseConsoleString() {
        return Debug.convertThrowableToClickableEclipseConsoleString(new Exception());
    }

    public static final String getSetting(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    public static final boolean isFlagSet(String flag) {
        return BasicNumberUtils.getBoolean((String)Debug.getSetting(flag));
    }

    public Debug() {
        this(false);
    }

    public Debug(boolean paused) {
        this.mPaused = paused;
        this.resetTimer();
    }

    public void add(Debug other) {
        boolean wasPaused = this.pauseTimer();
        boolean otherWasPaused = other.pauseTimer();
        this.mStartTime -= other.mPausedAt - other.mStartTime;
        if (!otherWasPaused) {
            other.resumeTimer();
        }
        if (!wasPaused) {
            this.resumeTimer();
        }
    }

    public double getElapsed() {
        return (double)(System.currentTimeMillis() - this.mStartTime) / 1000.0;
    }

    public boolean pauseTimer() {
        boolean wasPaused = this.mPaused;
        if (!wasPaused) {
            this.mPausedAt = System.currentTimeMillis();
            this.mPaused = true;
        }
        return wasPaused;
    }

    public void resetTimer() {
        this.mPausedAt = this.mStartTime = System.currentTimeMillis();
    }

    public void resumeTimer() {
        this.mPaused = false;
        this.mStartTime += System.currentTimeMillis() - this.mPausedAt;
    }

    public void subtract(Debug other) {
        boolean wasPaused = this.pauseTimer();
        boolean otherWasPaused = other.pauseTimer();
        this.mStartTime += other.mPausedAt - other.mStartTime;
        if (!otherWasPaused) {
            other.resumeTimer();
        }
        if (!wasPaused) {
            this.resumeTimer();
        }
    }

    public String toString() {
        boolean wasPaused = this.pauseTimer();
        double seconds = (double)(this.mPausedAt - this.mStartTime) / 1000.0;
        String result = MessageFormat.format("{0,number,0.000}", seconds);
        if (!wasPaused) {
            this.resumeTimer();
        }
        return result;
    }
}

