/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbInstalledPackage;
import com.arm.streamline.deviceconn.adb.utils.AdbPackageEnumeration;
import com.arm.streamline.ui.StreamlineUIPlugin;
import com.arm.streamline.ui.part.lpv.AndroidPackage;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IPackageDetector;
import com.arm.utils.collections.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidPackageDetector
implements IPackageDetector {
    private static final @NonNull Supplier<@NonNull ExecutorService> EXECUTOR_SERVICE_FACTORY = () -> ForkJoinPool.commonPool();
    private final @NonNull Function<@NonNull IAndroidTargetDevice, @Nullable IAdbCommandRunner> adbCommandRunnerSupplier;
    private final @NonNull ExecutorService executorService;
    private final @NonNull PackageRequestor requestor;

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidPackage.Status debuggability(@NonNull AdbInstalledPackage inputPackage) {
        return inputPackage.isDebuggable() ? IAndroidPackage.Status.DEBUGGABLE : IAndroidPackage.Status.NON_DEBUGGABLE;
    }

    private static @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> emptyResult() {
        return new Pair((Object)0, Collections.emptySet().stream());
    }

    private static @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> requestEnumeration(@NonNull IAdbCommandRunner adbCommandRunner, boolean onlyDebuggable, @NonNull BooleanSupplier cancelledSupplier) {
        try {
            AdbPackageEnumeration enumerator = new AdbPackageEnumeration(adbCommandRunner, cancelledSupplier);
            return enumerator.enumerateAsync(onlyDebuggable);
        }
        catch (IOException ex) {
            StreamlineUIPlugin.warning((String)("Could not query adb for installed packages on device " + adbCommandRunner.getDeviceSerial()), (Throwable)ex);
            return AndroidPackageDetector.emptyResult();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull List<@NonNull IAndroidPackage> transformPackage(@NonNull AdbInstalledPackage inputPackage) {
        ArrayList<@NonNull IAndroidPackage> uiPackageList = new ArrayList<IAndroidPackage>();
        IAndroidPackage.Status debuggability = AndroidPackageDetector.debuggability(inputPackage);
        @NonNull Set activities = inputPackage.getMainActivities();
        for (String activity : activities) {
            uiPackageList.add(new AndroidPackage(inputPackage.getPackageName(), activity, debuggability));
        }
        return uiPackageList;
    }

    private static @NonNull Stream<@NonNull List<@NonNull IAndroidPackage>> transformPackages(@NonNull Stream<@NonNull AdbInstalledPackage> packages) {
        return packages.map(p -> AndroidPackageDetector.transformPackage(p));
    }

    public AndroidPackageDetector(@NonNull Function<@NonNull IAndroidTargetDevice, @Nullable IAdbCommandRunner> adbCommandRunnerSupplier) {
        this(adbCommandRunnerSupplier, EXECUTOR_SERVICE_FACTORY, PackageRequestor.DEFAULT);
    }

    AndroidPackageDetector(@NonNull Function<@NonNull IAndroidTargetDevice, @Nullable IAdbCommandRunner> adbCommandRunnerSupplier, @NonNull Supplier<@NonNull ExecutorService> executorServiceFactory, @NonNull PackageRequestor requestor) {
        this.adbCommandRunnerSupplier = adbCommandRunnerSupplier;
        this.requestor = requestor;
        this.executorService = executorServiceFactory.get();
    }

    private void requestPackageListTask(@NonNull IAndroidTargetDevice selectedDevice, boolean onlyDebuggable, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageTaskProgressConsumer consumer, @NonNull BooleanSupplier cancelledSupplier, @NonNull IntConsumer totalConsumer, @NonNull IntUnaryOperator progressModifier) {
        try {
            IAdbCommandRunner commandRunner = this.adbCommandRunnerSupplier.apply(selectedDevice);
            Pair<Integer, Stream<AdbInstalledPackage>> packages = commandRunner != null ? this.requestor.requestPackages(commandRunner, onlyDebuggable, cancelledSupplier) : AndroidPackageDetector.emptyResult();
            Stream<List<IAndroidPackage>> transformed = AndroidPackageDetector.transformPackages((Stream)packages.second);
            int total = (Integer)packages.first;
            totalConsumer.accept(total);
            List list = transformed.takeWhile(l -> !cancelledSupplier.getAsBoolean()).map(l -> {
                consumer.progress(selectedDevice, progressModifier.applyAsInt(1), total);
                return l;
            }).flatMap(l -> l.stream()).collect(Collectors.toList());
            if (!cancelledSupplier.getAsBoolean()) {
                consumer.complete(selectedDevice, onlyDebuggable, list);
            } else {
                consumer.cancelled(selectedDevice);
            }
        }
        catch (CancellationException e) {
            consumer.cancelled(selectedDevice);
        }
        catch (Throwable e) {
            consumer.cancelled(selectedDevice);
            e.printStackTrace();
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageDetectorTask requestPackageList(final @NonNull IAndroidTargetDevice selectedDevice, boolean onlyDebuggable, final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageTaskProgressConsumer consumer) {
        final AtomicBoolean completedFlag = new AtomicBoolean(false);
        final AtomicBoolean cancelledFlag = new AtomicBoolean(false);
        final AtomicInteger progressCounter = new AtomicInteger(0);
        final AtomicInteger totalCounter = new AtomicInteger(0);
        this.executorService.execute(() -> {
            try {
                this.requestPackageListTask(selectedDevice, onlyDebuggable, consumer, cancelledFlag::get, totalCounter::set, progressCounter::addAndGet);
            }
            finally {
                completedFlag.set(true);
            }
        });
        return new IPackageDetector.IPackageDetectorTask(){

            public @NonNull IAndroidTargetDevice getSelectedDevice() {
                return selectedDevice;
            }

            public void dispose() {
                cancelledFlag.set(true);
            }

            public void requestProgress() {
                if (!completedFlag.get()) {
                    consumer.progress(selectedDevice, progressCounter.get(), totalCounter.get());
                }
            }
        };
    }

    public static interface PackageRequestor {
        public static final @NonNull PackageRequestor DEFAULT = new PackageRequestor(){

            @Override
            public @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> requestPackages(@NonNull IAdbCommandRunner adbCommandRunner, boolean onlyDebuggable, @NonNull BooleanSupplier cancelledSupplier) {
                return AndroidPackageDetector.requestEnumeration(adbCommandRunner, onlyDebuggable, cancelledSupplier);
            }
        };

        public @NonNull Pair<@NonNull Integer, @NonNull Stream<@NonNull AdbInstalledPackage>> requestPackages(@NonNull IAdbCommandRunner var1, boolean var2, @NonNull BooleanSupplier var3);
    }
}

