/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.application.HelpContexts;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.databrowser.DeviceConnectionModel;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.browser.TargetBrowserAdapter;
import com.arm.streamline.ui.part.LandingPageActionHandler;
import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.part.lpv.AdbPathPreferenceModel;
import com.arm.streamline.ui.part.lpv.AndroidDeviceModel;
import com.arm.streamline.ui.part.lpv.AndroidTargetLauncher;
import com.arm.streamline.ui.part.lpv.TargetBrowserModel;
import com.arm.streamline.ui.part.lpv.TcpTargetLauncher;
import com.arm.streamline.ui.vm.IAndroidDeviceModel;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageSceneViewModel;
import com.arm.streamline.ui.vm.LandingPageSceneViewModel;
import com.arm.streamline.ui.workbench.FXViewPart;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.scene.Scene;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class LandingPageView
extends FXViewPart {
    public static final @NonNull String ID = "streamline.view.LandingPageView";
    private final @NonNull ILandingPageSceneViewModel controller;
    private @Nullable LandingPageScene scene;
    private final @NonNull TargetBrowserModel targetBrowserModel;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull AndroidDeviceModel androidDeviceManager;

    public LandingPageView() throws PartInitException {
        IDeviceConnectionModel deviceConnectionModel = DeviceConnectionModel.get();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchBrowserSupport browserSupport = workbench.getBrowserSupport();
        LandingPageActionHandler actionHandler = new LandingPageActionHandler(deviceConnectionModel, (IWorkbenchHelpSystem)NullChecking.neverNull((Object)workbench.getHelpSystem()), (IWebBrowser)NullChecking.neverNull((Object)browserSupport.getExternalBrowser()));
        AdbRunnerFactory adbRunnerFactory = new AdbRunnerFactory();
        this.adbPathModel = new AdbPathPreferenceModel(StreamlinePreferences.getPreferenceStore(), StreamlinePreferences.getApplicationPreferences());
        this.androidDeviceManager = new AndroidDeviceModel(adbRunnerFactory);
        this.controller = new LandingPageSceneViewModel((ILandingPageActionHandler)actionHandler, deviceConnectionModel.hasActiveConnectionProperty(), TcpTargetLauncher::create, AndroidTargetLauncher::create, (IAndroidDeviceModel)this.androidDeviceManager, this.adbPathModel);
        this.targetBrowserModel = new TargetBrowserModel(this.adbPathModel, TargetBrowserAdapter::new);
        Bindings.bindContent((List)this.controller.getTcpSubViewViewModel().detectedDevicesProperty(), this.targetBrowserModel.tcpTargetDevicesProperty());
    }

    public void dispose() {
        this.targetBrowserModel.dispose();
        this.androidDeviceManager.dispose();
        super.dispose();
    }

    protected @NonNull Scene createFxScene() {
        assert (this.scene == null);
        try {
            LandingPageScene scene;
            this.scene = scene = new LandingPageScene(this.controller, true, true);
            return scene.getScene();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        LandingPageScene scene = this.scene;
        if (scene != null) {
            scene.addListenersToScene();
        }
    }

    protected @Nullable String getHelpId() {
        return HelpContexts.LANDING_PAGE_CONTEXT_ID;
    }

    protected void setFxFocus() {
        LandingPageScene scene = this.scene;
        if (scene != null) {
            scene.getScene().getRoot().requestFocus();
        }
    }
}

