/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.JsonLineMetric;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.Map;

public class LineChart
extends Element {
    private double[] xdata;
    private double[] ydata;
    private String xlabel;
    private String ylabel;
    private String group;

    public LineChart(String xlabel, String ylabel, double[] xdata, double[] ydata, String group) {
        super(ElementType.LINE);
        if (xdata.length != ydata.length) {
            throw new LogicError("LineChart: array lengths inconsistent");
        }
        DoubleSummaryStatistics xstats = Arrays.stream(xdata).summaryStatistics();
        DoubleSummaryStatistics ystats = Arrays.stream(ydata).summaryStatistics();
        if (Double.isNaN(xstats.getSum()) || Double.isNaN(ystats.getSum())) {
            throw new LogicError("LineChart: NaN values found");
        }
        this.xlabel = xlabel;
        this.ylabel = ylabel;
        this.xdata = xdata;
        this.ydata = ydata;
        this.group = group;
    }

    public double[] getXData() {
        return this.xdata;
    }

    public double[] getYData() {
        return this.ydata;
    }

    public String getXLabel() {
        return this.xlabel;
    }

    public String getYLabel() {
        return this.ylabel;
    }

    public String getGroup() {
        return this.group;
    }

    public Map<String, JsonLineMetric> asMap(int[] centiles) {
        JsonLineMetric lineChartJson = new JsonLineMetric(this.ydata, centiles);
        HashMap<String, JsonLineMetric> jsonObj = new HashMap<String, JsonLineMetric>();
        jsonObj.put(LineChart.formatPropertyName(this.ylabel), lineChartJson);
        return jsonObj;
    }
}

