/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.section.FpsBoundnessChart;
import com.arm.streamline.performanceadvisor.section.JsonLineMetric;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;

public class FpsBoundnessChartSerialiser
implements JsonSerializer<FpsBoundnessChart> {
    private Gson gson;

    public FpsBoundnessChartSerialiser(Gson gson) {
        this.gson = gson;
    }

    public JsonElement serialize(FpsBoundnessChart chart, Type type, JsonSerializationContext ctx) {
        return this.asJsonObject(chart);
    }

    private JsonObject asJsonObject(FpsBoundnessChart chart) {
        JsonObject jsonObj = new JsonObject();
        JsonLineMetric interactiveChartJson = new JsonLineMetric(chart.getYData(), chart.getCentiles());
        jsonObj.add(chart.getYLabel().equals("ms/F") ? "frameTime" : "frameRate", this.gson.toJsonTree((Object)interactiveChartJson));
        jsonObj.add("vsync", FpsBoundnessChartSerialiser.renderVsync(chart));
        return jsonObj;
    }

    private static JsonElement renderVsync(FpsBoundnessChart chart) {
        JsonObject vsyncJson = new JsonObject();
        vsyncJson.addProperty("target", (Number)((int)chart.getVsync()));
        long count = Arrays.stream(chart.getYData()).filter(c -> c < chart.getVsync()).count();
        vsyncJson.addProperty("percentageTimeUnderTarget", (Number)(100L * count / (long)chart.getYData().length));
        return vsyncJson;
    }
}

