/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.Screenshot;
import com.arm.streamline.performanceadvisor.section.BoundnessRegion;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.FpsBoundnessChartFrameRateJsonElement;
import com.arm.streamline.performanceadvisor.section.FpsBoundnessChartFrameTimeJsonElement;
import com.arm.streamline.performanceadvisor.section.JsonReportElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FpsBoundnessChart
extends Element {
    private double xdataStart = 0.0;
    private int xdataLength = 0;
    private double xdataStep = 0.0;
    private double[] ydata = new double[0];
    private String ylabel = "";
    private double vsync = 0.0;
    private List<BoundnessRegion> boundness = Collections.emptyList();
    private List<Region> regions = Collections.emptyList();
    private List<Screenshot> screenshots = Collections.emptyList();
    private List<Integer> screenshotBins = Collections.emptyList();
    private List<String> screenshotPathList = Collections.emptyList();
    private String group = "";
    private int[] centiles = new int[0];
    private Map<String, Integer> vsyncStats = new HashMap<String, Integer>();
    private LinkedHashMap<String, String> boundnessTypesWithCssRules = new LinkedHashMap();

    private FpsBoundnessChart() {
        super(ElementType.INTERACTIVE);
    }

    public double[] getYData() {
        return this.ydata;
    }

    public double getVsync() {
        return this.vsync;
    }

    public String getYLabel() {
        return this.ylabel;
    }

    public double getXdataStart() {
        return this.xdataStart;
    }

    public int getXdataLength() {
        return this.xdataLength;
    }

    public double getXdataStep() {
        return this.xdataStep;
    }

    public List<BoundnessRegion> getBoundness() {
        return this.boundness;
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public List<Integer> getScreenshotBins() {
        return this.screenshotBins;
    }

    public List<String> getScreenshotPathList() {
        return this.screenshotPathList;
    }

    public String getGroup() {
        return this.group;
    }

    public int[] getCentiles() {
        return this.centiles;
    }

    public JsonReportElement<FpsBoundnessChart> asJsonReportElement() {
        if (this.getYLabel().equals("ms/F")) {
            return new FpsBoundnessChartFrameTimeJsonElement(this);
        }
        return new FpsBoundnessChartFrameRateJsonElement(this);
    }

    public Map<String, Integer> getVsyncStats() {
        return this.vsyncStats;
    }

    public static FpsBoundnessChartBuilder builder() {
        return new FpsBoundnessChartBuilder();
    }

    public static class FpsBoundnessChartBuilder {
        private FpsBoundnessChart chart = new FpsBoundnessChart();

        public FpsBoundnessChartBuilder setXAxis(double xdataStart, int xdataLength, double xdataStep) {
            this.chart.xdataStart = xdataStart;
            this.chart.xdataLength = xdataLength;
            this.chart.xdataStep = xdataStep;
            return this;
        }

        public FpsBoundnessChartBuilder setYAxis(double[] ydata, String ylabel) {
            this.chart.ydata = ydata;
            this.chart.ylabel = ylabel;
            return this;
        }

        public FpsBoundnessChartBuilder setVSync(double vsync) {
            this.chart.vsync = vsync;
            return this;
        }

        public FpsBoundnessChartBuilder setBoundness(List<BoundnessRegion> boundness) {
            this.chart.boundness = boundness;
            return this;
        }

        public FpsBoundnessChartBuilder setRegions(List<Region> regions) {
            this.chart.regions = regions;
            return this;
        }

        public FpsBoundnessChartBuilder setGroup(String group) {
            this.chart.group = group;
            return this;
        }

        public FpsBoundnessChartBuilder setCentiles(int[] centiles) {
            this.chart.centiles = centiles;
            return this;
        }

        public FpsBoundnessChartBuilder addScreenshots(List<Screenshot> screenshots, List<Integer> screenshotBins, List<String> screenshotPathList) {
            this.chart.screenshots = screenshots;
            this.chart.screenshotBins = screenshotBins;
            this.chart.screenshotPathList = screenshotPathList;
            return this;
        }

        public FpsBoundnessChart build() {
            this.calculateVsyncStats();
            return this.chart;
        }

        private void calculateVsyncStats() {
            this.chart.vsyncStats = new HashMap<String, Integer>();
            long count = Arrays.stream(this.chart.getYData()).filter(c -> c < this.chart.getVsync()).count();
            Integer percentageTimeUnderTarget = (int)(100L * count / (long)this.chart.getYData().length);
            this.chart.vsyncStats.put("percentageTimeUnderTarget", percentageTimeUnderTarget);
            Integer target = (int)this.chart.getVsync();
            this.chart.vsyncStats.put("target", target);
        }

        public FpsBoundnessChartBuilder setBoundnessTypesWithCssRules(LinkedHashMap<String, String> boundnessTypesWithCssRules) {
            this.chart.boundnessTypesWithCssRules = boundnessTypesWithCssRules;
            return this;
        }
    }
}

