/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.AnalyserLibrary;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.io.DefaultFileName;
import com.arm.streamline.performanceadvisor.renderer.Renderer;
import com.arm.streamline.performanceadvisor.renderer.RendererOptions;
import com.arm.streamline.performanceadvisor.report.Report;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;

public abstract class ReportHandler {
    private final String type;
    private final boolean hide;
    private Report report;
    private AnalyserLibrary library;
    static final String DEFAULT_REPORT_PREFIX = "performance_advisor-";

    public ReportHandler(String type) {
        this.type = type;
        this.hide = false;
    }

    public ReportHandler(String type, boolean hide) {
        this.type = type;
        this.hide = hide;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean isHidden() {
        return this.hide;
    }

    public abstract Report createReport();

    public abstract Renderer createRenderer(RendererOptions var1);

    public abstract String getDescription();

    public abstract String getDefaultFilename();

    public final ProblemList initialise(CaptureData captureData, AnalyserLibrary library, boolean progress) {
        Application.LOG.info(() -> "Initialise report type: " + this.type);
        this.library = library;
        this.report = this.createReport();
        return this.report.initialise(captureData, library, progress);
    }

    public final void execute(RendererOptions rendererOptions, Path destination, boolean progress) {
        Application.LOG.info(() -> "Generate report type " + this.type + " at location " + String.valueOf(destination));
        try {
            this.createRenderer(rendererOptions).render(this.report.execute(this.library, progress), destination);
        }
        catch (FileNotFoundException e) {
            throw new FatalError("Could not open output file. " + e.getMessage());
        }
        catch (IOException e) {
            throw new FatalError("Error when writing to output file.");
        }
    }

    public String defaultBasename() {
        return DefaultFileName.nameWithTimestamp();
    }
}

