/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.report.GroupDefinition;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ReportDefinition {
    private List<GroupDefinition> groups;

    public ReportDefinition(List<GroupDefinition> groups) {
        this.groups = groups;
    }

    public List<GroupDefinition> getGroups() {
        if (this.groups != null) {
            return this.groups;
        }
        return Collections.emptyList();
    }

    public List<SectionDefinition> getCharts() {
        ArrayList<SectionDefinition> combinedList = new ArrayList<SectionDefinition>();
        for (GroupDefinition group : this.getGroups()) {
            combinedList.addAll(group.getCharts());
        }
        return combinedList;
    }

    public int hashCode() {
        return Objects.hash(this.getGroups());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        return Objects.equals(this.getGroups(), other.getGroups());
    }
}

