/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.report.ReportHandler;
import java.util.HashMap;
import java.util.Iterator;

public class HandlerRegistry
implements Iterable<ReportHandler> {
    private HashMap<String, ReportHandler> handlerMap = new HashMap();

    @Override
    public Iterator<ReportHandler> iterator() {
        return this.handlerMap.values().iterator();
    }

    public void register(ReportHandler handler) {
        String type = handler.getType();
        if (this.handlerMap.containsKey(type)) {
            throw new LogicError("Attempt to register handler for existing type: " + type);
        }
        this.handlerMap.put(type, handler);
    }

    public void replaceHandler(ReportHandler handler) {
        String type = handler.getType();
        ReportHandler oldHandler = this.handlerMap.replace(type, handler);
        if (oldHandler == null) {
            throw new LogicError("No existing handler for type: " + type);
        }
    }

    public boolean isKnownType(String type) {
        return this.handlerMap.containsKey(type);
    }

    public ReportHandler getHandler(String type) {
        ReportHandler handler = this.handlerMap.get(type);
        if (handler == null) {
            throw new LogicError("Failed to find handler for type: " + type);
        }
        return handler;
    }

    public int getMaxTypeLength() {
        int maxLength = 0;
        for (String i : this.handlerMap.keySet()) {
            maxLength = Math.max(maxLength, i.length());
        }
        return maxLength;
    }

    public int getMaxDescriptionLength() {
        int maxLength = 0;
        for (ReportHandler i : this.handlerMap.values()) {
            maxLength = Math.max(maxLength, i.getDescription().length());
        }
        return maxLength;
    }
}

