/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.report;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserLibrary;
import com.arm.streamline.performanceadvisor.analyser.GroupAnalyser;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.report.GroupDefinition;
import com.arm.streamline.performanceadvisor.report.SectionSpec;
import java.util.Objects;

public class GroupSpec
extends SectionSpec {
    private GroupDefinition groupDefn;

    public GroupSpec(GroupDefinition groupDefn, int userRegion) {
        super(userRegion);
        this.groupDefn = groupDefn;
    }

    @Override
    public String getName() {
        return "Custom group: " + this.groupDefn.getTitle().orElse("(no title)");
    }

    @Override
    public Analyser create(CaptureData captureData, AnalyserLibrary library) {
        return new GroupAnalyser(captureData, this.groupDefn);
    }

    public int hashCode() {
        return Objects.hash(this.groupDefn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSpec)) {
            return false;
        }
        GroupSpec other = (GroupSpec)obj;
        return Objects.equals(this.groupDefn, other.groupDefn);
    }
}

