/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.Diffable;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import java.util.ArrayList;
import java.util.List;

public class JsonRegionSection
implements Diffable<JsonRegionSection, JsonRegionSection> {
    private String name;
    private List<JsonSection> sections;

    public JsonRegionSection(String name, List<JsonSection> sections) {
        this.name = name;
        this.sections = sections;
    }

    public String getName() {
        return this.name;
    }

    public List<JsonSection> getSections() {
        return this.sections;
    }

    @Override
    public JsonRegionSection diff(JsonRegionSection other) {
        if (!this.name.equals(other.name)) {
            throw new IllegalArgumentException("Region names do not match");
        }
        ArrayList<JsonSection> sectionsDiff = new ArrayList<JsonSection>();
        int i = 0;
        while (i < this.sections.size()) {
            JsonSection thisSection = this.sections.get(i);
            JsonSection otherSection = other.sections.get(i);
            JsonSection diffSection = thisSection.diff(otherSection);
            sectionsDiff.add(diffSection);
            ++i;
        }
        return new JsonRegionSection(this.name, sectionsDiff);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sections == null ? 0 : this.sections.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRegionSection other = (JsonRegionSection)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.sections == null ? other.sections != null : !this.sections.equals(other.sections));
    }

    public String toString() {
        return "JsonRegionSection [name=" + this.name + ", sections=" + String.valueOf(this.sections) + "]";
    }
}

