/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.DirectoryReadPathValidator;
import com.arm.streamline.performanceadvisor.io.FileReadPathValidator;
import com.arm.streamline.performanceadvisor.io.FileWritePathValidator;
import com.arm.streamline.performanceadvisor.io.PathValidator;
import com.arm.streamline.performanceadvisor.io.ReadPathValidator;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;

public class PathValidation {
    private PathValidation() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    private static void fatalErrorIfInvalid(PathValidator validator) {
        if (validator.hasError()) {
            throw new FatalError(validator.getMessage());
        }
    }

    public static void fatalErrorIfInvalidReadableFile(UserProvidedPath path) {
        PathValidation.fatalErrorIfInvalid(new FileReadPathValidator(path));
    }

    public static void fatalErrorIfInvalidReadableDirectory(UserProvidedPath path) {
        PathValidation.fatalErrorIfInvalid(new DirectoryReadPathValidator(path));
    }

    public static void fatalErrorIfInvalidForFileOrDirectoryRead(UserProvidedPath path) {
        PathValidation.fatalErrorIfInvalid(new ReadPathValidator(path));
    }

    public static void fatalErrorIfInvalidForFileWrite(UserProvidedPath path) {
        PathValidation.fatalErrorIfInvalid(new FileWritePathValidator(path));
    }
}

