/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.DataProviderSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import java.util.Iterator;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;

public class ShaderCoreSeries
extends StreamlineSeries {
    private OptionalInt shaderCoreCount;

    public ShaderCoreSeries(@NonNull CounterDescriptor descriptor, boolean isOptional, OptionalInt shaderCoreCount) {
        super(descriptor, isOptional, false);
        this.shaderCoreCount = shaderCoreCount;
    }

    @Override
    public Iterator<Double> iterator(int start, int end) {
        Application.LOG.fine(() -> String.format("ShaderCoreSeries.iterator(%d, %d) for %s", start, end, this.getName()));
        if (start < 0 || start > end || end > this.length || this.length != 0 && start >= this.length) {
            throw new LogicError("Invalid iterator range for series " + this.getName());
        }
        return new ShaderCoreSourceIterator(start, end);
    }

    private class ShaderCoreSourceIterator
    extends DataProviderSeries.StreamlineSourceIterator {
        public ShaderCoreSourceIterator(int startIndex, int endIndex) {
            super(startIndex, endIndex);
        }

        @Override
        public Double next() {
            Double next = super.next();
            if (ShaderCoreSeries.this.shaderCoreCount.isPresent()) {
                next = next / (double)ShaderCoreSeries.this.shaderCoreCount.getAsInt();
            }
            return next;
        }
    }
}

