/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.counterseries.ArraySeries;
import com.arm.streamline.performanceadvisor.section.Unit;

public class FrameMetricSeries
extends ArraySeries {
    private boolean displayMspf;
    private double[] msPerFrame;
    private static final double MS_PER_SECOND = 1000.0;

    public FrameMetricSeries(String name, double[] series, boolean displayMspf) {
        super(name, series);
        this.displayMspf = displayMspf;
        this.msPerFrame = new double[this.getLength()];
        int i = 0;
        while (i < this.getLength()) {
            if (this.toArray()[i] != 0.0) {
                this.msPerFrame[i] = 1000.0 / this.toArray()[i];
            }
            ++i;
        }
    }

    public double getFpsAt(int index) {
        if (index >= 0 && index < this.getLength()) {
            return this.getFps().toArray()[index];
        }
        return 0.0;
    }

    public ArraySeries getSeriesToDisplay() {
        if (this.displayMspf) {
            return new ArraySeries("msPerFrame", this.msPerFrame);
        }
        return this;
    }

    public ArraySeries getMspf() {
        return new ArraySeries("msPerFrame", this.msPerFrame);
    }

    public ArraySeries getFps() {
        return this;
    }

    public String getNameToDisplayShort() {
        if (this.displayMspf) {
            return "ms/F";
        }
        return "FPS";
    }

    public boolean getDisplayMspf() {
        return this.displayMspf;
    }

    public String getNameToDisplayLong() {
        if (this.displayMspf) {
            return "frame time";
        }
        return "frame rate";
    }

    public Unit getUnitToDisplay() {
        if (this.displayMspf) {
            return Unit.MS;
        }
        return Unit.FPS;
    }
}

