/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.counterseries.DataProviderSeries;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExpressionSeries
extends DataProviderSeries {
    public static final String SERIES_NOT_FOUND_WARNING = "WARNING: The series \"%s\" could not be found. \nEnsure that you are running a capture made with a matching version of Streamline and that all the expression values in your report configuration are correct.";
    private static final String SERIES_NOT_FOUND_LOG = "Series \"%s\" provided by expression %s could not be found.";
    private @NonNull String expression;
    private @Nullable String units;
    private boolean isAverage;
    private boolean isPerFrame;
    private boolean isMax;
    private boolean isMin;
    private boolean doNotShowIfAllZeroes;

    public ExpressionSeries(@NonNull String name, @NonNull String expression, @Nullable String units, boolean isAverage, boolean isPerFrame, boolean isMax, boolean isMin, boolean doNotShowIfAllZeroes) {
        super(name);
        this.expression = expression;
        this.units = units;
        this.isAverage = isAverage;
        this.isPerFrame = isPerFrame;
        this.isMax = isMax;
        this.isMin = isMin;
        this.doNotShowIfAllZeroes = doNotShowIfAllZeroes;
    }

    @Override
    protected Optional<ISeriesDataProvider> initialiseDataSource(CaptureData captureData) {
        Optional<ISeriesDataProvider> provider = captureData.getSeriesForExpression(this.expression, this.units);
        if (provider.isPresent()) {
            if (this.isAverage) {
                provider.get().getConfig().setDisplay(CounterDisplay.AVERAGE);
            }
            if (this.isMax) {
                provider.get().getConfig().setDisplay(CounterDisplay.MAXIMUM);
            }
            if (this.isMin) {
                provider.get().getConfig().setDisplay(CounterDisplay.MINIMUM);
            }
        } else {
            System.err.println(String.format(SERIES_NOT_FOUND_WARNING, this.getName()));
            Application.LOG.warning(String.format(SERIES_NOT_FOUND_LOG, this.getName(), this.expression));
        }
        return provider;
    }

    @Override
    public boolean isAverage() {
        return this.isAverage;
    }

    @Override
    public boolean isPerFrame() {
        return this.isPerFrame;
    }

    @Override
    public boolean isMaximum() {
        return this.isMax;
    }

    @Override
    public boolean isMinimum() {
        return this.isMin;
    }

    @Override
    public boolean doNotShowIfAllZeroes() {
        return this.doNotShowIfAllZeroes;
    }
}

